/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ServiceWarningAction
extends AbstractAction {
    private final CentralAuthenticationService centralAuthenticationService;
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final CookieGenerator warnCookieGenerator;

    public ServiceWarningAction(CentralAuthenticationService authenticationService, AuthenticationSystemSupport authenticationSystemSupport, TicketRegistrySupport ticketRegistrySupport, CookieRetrievingCookieGenerator warnCookieGenerator) {
        this.centralAuthenticationService = authenticationService;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.warnCookieGenerator = warnCookieGenerator;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        Authentication authentication = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicket);
        if (authentication == null) {
            throw new InvalidTicketException((Throwable)new AuthenticationException("No authentication found for ticket " + ticketGrantingTicket), ticketGrantingTicket);
        }
        Credential credential = WebUtils.getCredential((RequestContext)context);
        AuthenticationResultBuilder authenticationResultBuilder = this.authenticationSystemSupport.establishAuthenticationContextFromInitial(authentication, credential);
        AuthenticationResult authenticationResult = authenticationResultBuilder.build((Service)service);
        ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, (Service)service, authenticationResult);
        WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
        if (request.getParameterMap().containsKey("ignorewarn") && Boolean.valueOf(request.getParameter("ignorewarn")).booleanValue()) {
            this.warnCookieGenerator.removeCookie(response);
        }
        return new Event((Object)this, "redirect");
    }
}

