/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GenericSuccessViewAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericSuccessViewAction.class);
    private final CentralAuthenticationService centralAuthenticationService;
    private final ServicesManager servicesManager;
    private final ServiceFactory serviceFactory;
    private final String redirectUrl;

    protected Event doExecute(RequestContext requestContext) {
        if (StringUtils.isNotBlank((CharSequence)this.redirectUrl)) {
            Service service = this.serviceFactory.createService(this.redirectUrl);
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            requestContext.getExternalContext().requestExternalRedirect(service.getId());
        } else {
            String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
            WebUtils.putPrincipal((RequestContext)requestContext, (Principal)this.getAuthenticationPrincipal(tgt));
        }
        return this.success();
    }

    public Principal getAuthenticationPrincipal(String ticketGrantingTicketId) {
        try {
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            return ticketGrantingTicket.getAuthentication().getPrincipal();
        }
        catch (InvalidTicketException e) {
            LOGGER.warn("Ticket-granting ticket [{}] cannot be found in the ticket registry.", (Object)e.getMessage());
            LOGGER.debug(e.getMessage(), (Throwable)e);
            LOGGER.warn("In the absence of valid TGT, the authentication principal cannot be determined. Returning [{}]", (Object)NullPrincipal.class.getSimpleName());
            return NullPrincipal.getInstance();
        }
    }

    @Generated
    public GenericSuccessViewAction(CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, ServiceFactory serviceFactory, String redirectUrl) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.servicesManager = servicesManager;
        this.serviceFactory = serviceFactory;
        this.redirectUrl = redirectUrl;
    }
}

