/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendTicketGrantingTicketAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTicketGrantingTicketAction.class);
    private final CentralAuthenticationService centralAuthenticationService;
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final SingleSignOnParticipationStrategy renewalStrategy;

    protected Event doExecute(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String ticketGrantingTicketValueFromCookie = WebUtils.getTicketGrantingTicketIdFrom((MutableAttributeMap)context.getFlowScope());
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicketId)) {
            LOGGER.debug("No ticket-granting ticket is found in the context.");
            return this.success();
        }
        if (WebUtils.isAuthenticatingAtPublicWorkstation((RequestContext)context)) {
            LOGGER.info("Authentication is at a public workstation. SSO cookie will not be generated. Requests will be challenged for authentication.");
        } else if (this.renewalStrategy.isParticipating(context)) {
            LOGGER.debug("Setting ticket-granting cookie for current session linked to [{}].", (Object)ticketGrantingTicketId);
            this.ticketGrantingTicketCookieGenerator.addCookie(context, ticketGrantingTicketId);
        } else {
            LOGGER.info("Authentication session is renewed but CAS is not configured to create the SSO session. SSO cookie will not be generated. Subsequent requests will be challenged for credentials.");
        }
        if (ticketGrantingTicketValueFromCookie != null && !ticketGrantingTicketId.equals(ticketGrantingTicketValueFromCookie)) {
            LOGGER.debug("Ticket-granting ticket from TGC does not match the ticket-granting ticket from context");
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketValueFromCookie);
        }
        return this.success();
    }

    @Generated
    public SendTicketGrantingTicketAction(CentralAuthenticationService centralAuthenticationService, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, SingleSignOnParticipationStrategy renewalStrategy) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.renewalStrategy = renewalStrategy;
    }
}

