/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.jdbc.authn.BaseJdbcAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public abstract class AbstractJdbcUsernamePasswordAuthenticationHandler<T extends BaseJdbcAuthenticationProperties>
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJdbcUsernamePasswordAuthenticationHandler.class);
    protected final JdbcTemplate jdbcTemplate;
    protected final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected final DataSource dataSource;
    protected final T properties;

    protected AbstractJdbcUsernamePasswordAuthenticationHandler(T properties, ServicesManager servicesManager, PrincipalFactory principalFactory, DataSource dataSource) {
        super(properties.getName(), servicesManager, principalFactory, Integer.valueOf(properties.getOrder()));
        this.properties = properties;
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
    }

    protected Map<String, List<Object>> collectPrincipalAttributes(Map<String, Object> dbFields) {
        HashMap<String, List<Object>> attributes = new HashMap<String, List<Object>>();
        Multimap principalAttributeMap = CoreAuthenticationUtils.transformPrincipalAttributesListIntoMultiMap((List)this.properties.getPrincipalAttributeList());
        principalAttributeMap.forEach((key, names) -> {
            Object attribute = dbFields.get(key);
            if (attribute != null) {
                LOGGER.debug("Found attribute [{}] from the query results", key);
                Set attributeNames = CollectionUtils.toCollection((Object)names);
                attributeNames.forEach(attrName -> {
                    LOGGER.debug("Principal attribute [{}] is virtually remapped/renamed to [{}]", key, attrName);
                    attributes.put(attrName.toString(), CollectionUtils.wrap((Object)attribute.toString()));
                });
            } else {
                LOGGER.warn("Requested attribute [{}] could not be found in the query results", key);
            }
        });
        return attributes;
    }

    @Generated
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Generated
    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public T getProperties() {
        return this.properties;
    }
}

