/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuthClientProfile;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuthUtils;
import org.apereo.cas.support.oauth.validator.OAuthValidator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.AbstractUsernamePasswordAuthenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;

public class OAuthClientAuthenticator
extends AbstractUsernamePasswordAuthenticator {
    private OAuthValidator validator;
    private ServicesManager servicesManager;

    public void validate(UsernamePasswordCredentials credentials, WebContext context) {
        String id = credentials.getUsername();
        String secret = credentials.getPassword();
        OAuthRegisteredService registeredService = OAuthUtils.getRegisteredOAuthService(this.servicesManager, id);
        if (!this.validator.checkServiceValid((RegisteredService)registeredService)) {
            throw new CredentialsException("Service invalid for client identifier: " + id);
        }
        if (!this.validator.checkClientSecret(registeredService, secret)) {
            throw new CredentialsException("Bad secret for client identifier: " + id);
        }
        OAuthClientProfile profile = new OAuthClientProfile();
        profile.setId(id);
        credentials.setUserProfile((CommonProfile)profile);
    }

    public OAuthValidator getValidator() {
        return this.validator;
    }

    public void setValidator(OAuthValidator validator) {
        this.validator = validator;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }
}

