/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Map;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.support.oauth.profile.OAuthUserProfile;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.AbstractUsernamePasswordAuthenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;

public class OAuthUserAuthenticator
extends AbstractUsernamePasswordAuthenticator {
    private AuthenticationSystemSupport authenticationSystemSupport;

    public void validate(UsernamePasswordCredentials credentials, WebContext context) {
        UsernamePasswordCredential casCredential = new UsernamePasswordCredential(credentials.getUsername(), credentials.getPassword());
        try {
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction(null, new Credential[]{casCredential});
            Authentication authentication = authenticationResult.getAuthentication();
            Principal principal = authentication.getPrincipal();
            OAuthUserProfile profile = new OAuthUserProfile();
            profile.setId(principal.getId());
            Map attributes = principal.getAttributes();
            if (attributes != null) {
                profile.addAttributes(attributes);
            }
            credentials.setUserProfile((CommonProfile)profile);
        }
        catch (AuthenticationException e) {
            throw new CredentialsException("Cannot login user using CAS internal authentication", (Throwable)e);
        }
    }

    public AuthenticationSystemSupport getAuthenticationSystemSupport() {
        return this.authenticationSystemSupport;
    }

    public void setAuthenticationSystemSupport(AuthenticationSystemSupport authenticationSystemSupport) {
        this.authenticationSystemSupport = authenticationSystemSupport;
    }
}

