/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import java.util.Optional;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthCallbackAuthorizeService;
import org.apereo.cas.validation.ValidationServiceSelectionStrategy;
import org.jasig.cas.client.util.URIBuilder;

public class OAuth20ValidationServiceSelectionStrategy
implements ValidationServiceSelectionStrategy {
    private static final long serialVersionUID = 8517547235465666978L;
    private ServicesManager servicesManager;
    private ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    public Service resolveServiceFrom(Service service) {
        URIBuilder builder = new URIBuilder(service.getId());
        Optional<URIBuilder.BasicNameValuePair> clientId = builder.getQueryParams().stream().filter(p -> p.getName().equals("client_id")).findFirst();
        Optional<URIBuilder.BasicNameValuePair> redirectUri = builder.getQueryParams().stream().filter(p -> p.getName().equals("redirect_uri")).findFirst();
        if (clientId.isPresent() && redirectUri.isPresent()) {
            return this.webApplicationServiceFactory.createService(redirectUri.get().getValue());
        }
        return service;
    }

    public boolean supports(Service service) {
        RegisteredService svc = this.servicesManager.findServiceBy(service);
        return svc instanceof OAuthCallbackAuthorizeService;
    }

    public int compareTo(ValidationServiceSelectionStrategy o) {
        return 0x7FFFFFFE;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setWebApplicationServiceFactory(ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }
}

