/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.profile.OAuthClientProfile;
import org.apereo.cas.support.oauth.profile.OAuthUserProfile;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthWebApplicationService;
import org.apereo.cas.support.oauth.util.OAuthUtils;
import org.apereo.cas.support.oauth.web.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.BaseOAuthWrapperController;
import org.apereo.cas.support.oauth.web.OAuthGrantType;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenFactory;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AccessTokenController
extends BaseOAuthWrapperController {
    @Autowired
    private CasConfigurationProperties casProperties;
    private RefreshTokenFactory refreshTokenFactory;
    private AccessTokenResponseGenerator accessTokenResponseGenerator;

    @RequestMapping(path={"/oauth2.0/accessToken"}, method={RequestMethod.POST})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Authentication authentication;
        OAuthWebApplicationService service;
        boolean generateRefreshToken;
        OAuthRegisteredService registeredService;
        response.setContentType("text/plain");
        if (!this.verifyAccessTokenRequest(request, response)) {
            this.logger.error("Access token request verification fails");
            return OAuthUtils.writeTextError(response, "invalid_request");
        }
        String grantType = request.getParameter("grant_type");
        J2EContext context = new J2EContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context);
        if (OAuth20AccessTokenController.isGrantType(grantType, OAuthGrantType.AUTHORIZATION_CODE) || OAuth20AccessTokenController.isGrantType(grantType, OAuthGrantType.REFRESH_TOKEN)) {
            Optional profile = manager.get(true);
            String clientId = ((UserProfile)profile.get()).getId();
            registeredService = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
            generateRefreshToken = registeredService != null && registeredService.isGenerateRefreshToken() != false && OAuth20AccessTokenController.isGrantType(grantType, OAuthGrantType.AUTHORIZATION_CODE);
            String parameterName = OAuth20AccessTokenController.isGrantType(grantType, OAuthGrantType.AUTHORIZATION_CODE) ? "code" : "refresh_token";
            OAuthToken token = this.getToken(request, parameterName);
            if (token == null) {
                this.logger.error("No token found for authorization_code or refresh_token grant types");
                return OAuthUtils.writeTextError(response, "invalid_grant");
            }
            service = token.getService();
            authentication = token.getAuthentication();
        } else {
            String clientId = request.getParameter("client_id");
            registeredService = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
            generateRefreshToken = registeredService != null && registeredService.isGenerateRefreshToken() != false;
            try {
                Optional profile = manager.get(true);
                if (!profile.isPresent()) {
                    throw new UnauthorizedServiceException("Oauth user profile cannot be determined");
                }
                service = this.createService((RegisteredService)registeredService);
                authentication = this.createAuthentication((UserProfile)profile.get(), (RegisteredService)registeredService, context);
                RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (Authentication)authentication);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return OAuthUtils.writeTextError(response, "invalid_grant");
            }
        }
        AccessToken accessToken = this.generateAccessToken((Service)service, authentication, context);
        RefreshToken refreshToken = null;
        if (generateRefreshToken) {
            refreshToken = this.refreshTokenFactory.create((Service)service, authentication);
            this.ticketRegistry.addTicket((Ticket)refreshToken);
        }
        this.logger.debug("access token: {} / timeout: {} / refresh token: {}", new Object[]{accessToken, this.casProperties.getTicket().getTgt().getTimeToKillInSeconds(), refreshToken});
        this.accessTokenResponseGenerator.generate(request, response, registeredService, (Service)service, accessToken, refreshToken, this.casProperties.getTicket().getTgt().getTimeToKillInSeconds());
        response.setStatus(200);
        return null;
    }

    private OAuthToken getToken(HttpServletRequest request, String parameterName) {
        String codeParameter = request.getParameter(parameterName);
        OAuthToken token = (OAuthToken)this.ticketRegistry.getTicket(codeParameter, OAuthToken.class);
        if (token == null || token.isExpired()) {
            this.logger.error("Code or refresh token expired: {}", (Object)token);
            if (token != null) {
                this.ticketRegistry.deleteTicket(token.getId());
            }
            return null;
        }
        if (token instanceof OAuthCode && !(token instanceof RefreshToken)) {
            this.ticketRegistry.deleteTicket(token.getId());
        }
        return token;
    }

    private boolean verifyAccessTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        String grantType = request.getParameter("grant_type");
        if (!this.checkGrantTypes(grantType, OAuthGrantType.AUTHORIZATION_CODE, OAuthGrantType.PASSWORD, OAuthGrantType.REFRESH_TOKEN)) {
            return false;
        }
        J2EContext context = new J2EContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context);
        Optional profile = manager.get(true);
        if (profile == null || !profile.isPresent()) {
            return false;
        }
        UserProfile uProfile = (UserProfile)profile.get();
        if (OAuth20AccessTokenController.isGrantType(grantType, OAuthGrantType.AUTHORIZATION_CODE)) {
            String clientId = uProfile.getId();
            String redirectUri = request.getParameter("redirect_uri");
            OAuthRegisteredService registeredService = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
            return uProfile instanceof OAuthClientProfile && this.validator.checkParameterExist(request, "redirect_uri") && this.validator.checkParameterExist(request, "code") && this.validator.checkCallbackValid((RegisteredService)registeredService, redirectUri);
        }
        if (OAuth20AccessTokenController.isGrantType(grantType, OAuthGrantType.REFRESH_TOKEN)) {
            return uProfile instanceof OAuthClientProfile && this.validator.checkParameterExist(request, "refresh_token");
        }
        String clientId = request.getParameter("client_id");
        OAuthRegisteredService registeredService = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
        return uProfile instanceof OAuthUserProfile && this.validator.checkParameterExist(request, "client_id") && this.validator.checkServiceValid((RegisteredService)registeredService);
    }

    private boolean checkGrantTypes(String type, OAuthGrantType ... expectedTypes) {
        this.logger.debug("Grant type: {}", (Object)type);
        for (OAuthGrantType expectedType : expectedTypes) {
            if (!OAuth20AccessTokenController.isGrantType(type, expectedType)) continue;
            return true;
        }
        this.logger.error("Unsupported grant type: {}", (Object)type);
        return false;
    }

    private static boolean isGrantType(String type, OAuthGrantType expectedType) {
        return expectedType != null && expectedType.name().toLowerCase().equals(type);
    }

    public void setAccessTokenResponseGenerator(AccessTokenResponseGenerator accessTokenResponseGenerator) {
        this.accessTokenResponseGenerator = accessTokenResponseGenerator;
    }

    public RefreshTokenFactory getRefreshTokenFactory() {
        return this.refreshTokenFactory;
    }

    public void setRefreshTokenFactory(RefreshTokenFactory refreshTokenFactory) {
        this.refreshTokenFactory = refreshTokenFactory;
    }
}

