/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthWebApplicationService;
import org.apereo.cas.support.oauth.util.OAuthUtils;
import org.apereo.cas.support.oauth.web.BaseOAuthWrapperController;
import org.apereo.cas.support.oauth.web.ConsentApprovalViewResolver;
import org.apereo.cas.support.oauth.web.OAuthResponseType;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.util.EncodingUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AuthorizeController
extends BaseOAuthWrapperController {
    protected OAuthCodeFactory oAuthCodeFactory;
    private ConsentApprovalViewResolver consentApprovalViewResolver;
    @Autowired
    private CasConfigurationProperties casProperties;

    @RequestMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        J2EContext context = new J2EContext(request, response);
        ProfileManager manager = new ProfileManager((WebContext)context);
        if (!this.verifyAuthorizeRequest(request) || !OAuth20AuthorizeController.isRequestAuthenticated(manager, context)) {
            this.logger.error("Authorize request verification fails");
            return new ModelAndView("casServiceErrorView");
        }
        String clientId = context.getRequestParameter("client_id");
        OAuthRegisteredService registeredService = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((String)clientId, (RegisteredService)registeredService);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new ModelAndView("casServiceErrorView");
        }
        ModelAndView mv = this.consentApprovalViewResolver.resolve(context, registeredService);
        if (!mv.isEmpty() && mv.hasView()) {
            return mv;
        }
        return this.redirectToCallbackRedirectUrl(manager, registeredService, context, clientId);
    }

    private static boolean isRequestAuthenticated(ProfileManager manager, J2EContext context) {
        Optional opt = manager.get(true);
        return opt.isPresent();
    }

    private ModelAndView redirectToCallbackRedirectUrl(ProfileManager manager, OAuthRegisteredService registeredService, J2EContext context, String clientId) throws Exception {
        Optional profile = manager.get(true);
        if (profile == null || !profile.isPresent()) {
            this.logger.error("Unexpected null profile from profile manager");
            return new ModelAndView("casServiceErrorView");
        }
        OAuthWebApplicationService service = this.createService((RegisteredService)registeredService);
        Authentication authentication = this.createAuthentication((UserProfile)profile.get(), (RegisteredService)registeredService, context);
        try {
            RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (Authentication)authentication);
        }
        catch (PrincipalException | UnauthorizedServiceException e) {
            this.logger.error(e.getMessage(), e);
            return new ModelAndView("casServiceErrorView");
        }
        String redirectUri = context.getRequestParameter("redirect_uri");
        this.logger.debug("Authorize request verification successful for client {} with redirect uri {}", (Object)clientId, (Object)redirectUri);
        String responseType = context.getRequestParameter("response_type");
        String callbackUrl = OAuth20AuthorizeController.isResponseType(responseType, OAuthResponseType.CODE) ? this.buildCallbackUrlForAuthorizationCodeResponseType(authentication, (Service)service, redirectUri) : this.buildCallbackUrlForImplicitResponseType(context, authentication, (Service)service, redirectUri);
        this.logger.debug("callbackUrl: {}", (Object)callbackUrl);
        return OAuthUtils.redirectTo(callbackUrl);
    }

    private String buildCallbackUrlForImplicitResponseType(J2EContext context, Authentication authentication, Service service, String redirectUri) throws Exception {
        String state = authentication.getAttributes().get("state").toString();
        String nonce = authentication.getAttributes().get("nonce").toString();
        AccessToken accessToken = this.generateAccessToken(service, authentication, context);
        this.logger.debug("Generated Oauth access token: {}", (Object)accessToken);
        URIBuilder builder = new URIBuilder(redirectUri);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("access_token").append('=').append(accessToken.getId()).append('&').append("token_type").append('=').append("bearer").append('&').append("expires_in").append('=').append(this.casProperties.getTicket().getTgt().getTimeToKillInSeconds());
        if (StringUtils.isNotBlank((CharSequence)state)) {
            stringBuilder.append('&').append("state").append('=').append(EncodingUtils.urlEncode((String)state));
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            stringBuilder.append('&').append("nonce").append('=').append(EncodingUtils.urlEncode((String)nonce));
        }
        builder.setFragment(stringBuilder.toString());
        return builder.toString();
    }

    private String buildCallbackUrlForAuthorizationCodeResponseType(Authentication authentication, Service service, String redirectUri) {
        OAuthCode code = this.oAuthCodeFactory.create(service, authentication);
        this.logger.debug("Generated OAuth code: {}", (Object)code);
        this.ticketRegistry.addTicket((Ticket)code);
        String state = authentication.getAttributes().get("state").toString();
        String nonce = authentication.getAttributes().get("nonce").toString();
        String callbackUrl = redirectUri;
        callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"code", (String)code.getId());
        if (StringUtils.isNotBlank((CharSequence)state)) {
            callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"state", (String)state);
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"nonce", (String)nonce);
        }
        return callbackUrl;
    }

    private boolean verifyAuthorizeRequest(HttpServletRequest request) {
        boolean checkParameterExist = this.validator.checkParameterExist(request, "client_id") && this.validator.checkParameterExist(request, "redirect_uri") && this.validator.checkParameterExist(request, "response_type");
        String responseType = request.getParameter("response_type");
        String clientId = request.getParameter("client_id");
        String redirectUri = request.getParameter("redirect_uri");
        OAuthRegisteredService registeredService = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
        return checkParameterExist && this.checkResponseTypes(responseType, OAuthResponseType.CODE, OAuthResponseType.TOKEN) && this.validator.checkServiceValid((RegisteredService)registeredService) && this.validator.checkCallbackValid((RegisteredService)registeredService, redirectUri);
    }

    private boolean checkResponseTypes(String type, OAuthResponseType ... expectedTypes) {
        this.logger.debug("Response type: {}", (Object)type);
        for (OAuthResponseType expectedType : expectedTypes) {
            if (!OAuth20AuthorizeController.isResponseType(type, expectedType)) continue;
            return true;
        }
        this.logger.error("Unsupported response type: {}", (Object)type);
        return false;
    }

    private static boolean isResponseType(String type, OAuthResponseType expectedType) {
        return expectedType != null && expectedType.name().toLowerCase().equals(type);
    }

    public OAuthCodeFactory getoAuthCodeFactory() {
        return this.oAuthCodeFactory;
    }

    public void setoAuthCodeFactory(OAuthCodeFactory oAuthCodeFactory) {
        this.oAuthCodeFactory = oAuthCodeFactory;
    }

    public void setConsentApprovalViewResolver(ConsentApprovalViewResolver consentApprovalViewResolver) {
        this.consentApprovalViewResolver = consentApprovalViewResolver;
    }
}

