/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.ConsentApprovalViewResolver;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20ConsentApprovalViewResolver
implements ConsentApprovalViewResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ConsentApprovalViewResolver.class);

    @Override
    public ModelAndView resolve(J2EContext context, OAuthRegisteredService service) {
        String bypassApprovalParameter = context.getRequestParameter("bypass_approval_prompt");
        LOGGER.debug("bypassApprovalParameter: {}", (Object)bypassApprovalParameter);
        if (StringUtils.isNotBlank((CharSequence)bypassApprovalParameter) || this.isConsentApprovalBypassed(context, service)) {
            return new ModelAndView();
        }
        return this.redirectToApproveView(context, service);
    }

    protected boolean isConsentApprovalBypassed(J2EContext context, OAuthRegisteredService service) {
        return service.isBypassApprovalPrompt();
    }

    protected ModelAndView redirectToApproveView(J2EContext ctx, OAuthRegisteredService svc) {
        String callbackUrl = ctx.getFullRequestURL();
        callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"bypass_approval_prompt", (String)"true");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("callbackUrl", callbackUrl);
        model.put("serviceName", svc.getName());
        LOGGER.debug("callbackUrl: {}", (Object)callbackUrl);
        return new ModelAndView("oauthConfirmView", model);
    }
}

