/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.support.oauth.util.OAuthUtils;
import org.apereo.cas.support.oauth.web.BaseOAuthWrapperController;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;

public class OAuth20ProfileController
extends BaseOAuthWrapperController {
    private static final String ID = "id";
    private static final String ATTRIBUTES = "attributes";

    @RequestMapping(path={"/oauth2.0/profile"}, produces={"application/json"})
    protected ResponseEntity<String> handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String authHeader;
        response.setContentType("application/json");
        String accessToken = request.getParameter("access_token");
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)(authHeader = request.getHeader("Authorization"))) && authHeader.toLowerCase().startsWith("Bearer".toLowerCase() + ' ')) {
            accessToken = authHeader.substring("Bearer".length() + 1);
        }
        this.logger.debug("{}: {}", (Object)"access_token", (Object)accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            this.logger.error("Missing {}", (Object)"access_token");
            LinkedMultiValueMap map = new LinkedMultiValueMap(1);
            map.add((Object)"error", (Object)"missing_accessToken");
            String value = OAuthUtils.jsonify((Map)map);
            return new ResponseEntity((Object)value, HttpStatus.UNAUTHORIZED);
        }
        AccessToken accessTokenTicket = (AccessToken)this.ticketRegistry.getTicket(accessToken, AccessToken.class);
        if (accessTokenTicket == null || accessTokenTicket.isExpired()) {
            this.logger.error("Expired access token: {}", (Object)"access_token");
            LinkedMultiValueMap map = new LinkedMultiValueMap(1);
            map.add((Object)"error", (Object)"expired_accessToken");
            String value = OAuthUtils.jsonify((Map)map);
            return new ResponseEntity((Object)value, HttpStatus.UNAUTHORIZED);
        }
        Map<String, Object> map = this.writeOutProfileResponse(accessTokenTicket.getAuthentication(), accessTokenTicket.getAuthentication().getPrincipal());
        String value = OAuthUtils.jsonify(map);
        return new ResponseEntity((Object)value, HttpStatus.OK);
    }

    protected Map<String, Object> writeOutProfileResponse(Authentication authentication, Principal principal) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ID, principal.getId());
        map.put(ATTRIBUTES, principal.getAttributes());
        return map;
    }
}

