/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.integration.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractPac4jAuthenticationHandler;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.Pac4jUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.InitializableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWrapperAuthenticationHandler<I extends Credential, C extends Credentials>
extends AbstractPac4jAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWrapperAuthenticationHandler.class);
    @NonNull
    protected ProfileCreator profileCreator = AuthenticatorProfileCreator.INSTANCE;

    public AbstractWrapperAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    public boolean supports(Credential credential) {
        return credential != null && this.getCasCredentialsType().isAssignableFrom(credential.getClass());
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential) throws GeneralSecurityException {
        C credentials = this.convertToPac4jCredentials(credential);
        LOGGER.debug("credentials: [{}]", credentials);
        try {
            Authenticator authenticator = this.getAuthenticator(credential);
            if (authenticator instanceof InitializableObject) {
                ((InitializableObject)authenticator).init();
            }
            authenticator.validate(credentials, AbstractWrapperAuthenticationHandler.getWebContext());
            CommonProfile profile = this.profileCreator.create(credentials, AbstractWrapperAuthenticationHandler.getWebContext());
            LOGGER.debug("profile: [{}]", (Object)profile);
            return this.createResult(new ClientCredential(credentials, authenticator.getClass().getSimpleName()), (UserProfile)profile);
        }
        catch (Exception e) {
            LOGGER.error("Failed to validate credentials", (Throwable)e);
            throw new FailedLoginException("Failed to validate credentials: " + e.getMessage());
        }
    }

    protected static WebContext getWebContext() {
        return Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)HttpRequestUtils.getHttpServletRequestFromRequestAttributes(), (HttpServletResponse)HttpRequestUtils.getHttpServletResponseFromRequestAttributes());
    }

    protected abstract C convertToPac4jCredentials(I var1) throws GeneralSecurityException;

    protected abstract Class<I> getCasCredentialsType();

    protected abstract Authenticator getAuthenticator(Credential var1);

    @Generated
    public void setProfileCreator(@NonNull ProfileCreator profileCreator) {
        if (profileCreator == null) {
            throw new NullPointerException("profileCreator is marked @NonNull but is null");
        }
        this.profileCreator = profileCreator;
    }
}

