/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.io.CommunicationsManager;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendPasswordResetInstructionsAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendPasswordResetInstructionsAction.class);
    public static final String PARAMETER_NAME_TOKEN = "pswdrst";
    protected final CasConfigurationProperties casProperties;
    protected final CommunicationsManager communicationsManager;
    protected final PasswordManagementService passwordManagementService;

    protected Event doExecute(RequestContext requestContext) {
        this.communicationsManager.validate();
        if (!this.communicationsManager.isMailSenderDefined()) {
            return this.error();
        }
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String username = request.getParameter("username");
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.warn("No username is provided");
            return this.error();
        }
        String to = this.passwordManagementService.findEmail(username);
        if (StringUtils.isBlank((CharSequence)to)) {
            LOGGER.warn("No recipient is provided");
            return this.error();
        }
        String url = SendPasswordResetInstructionsAction.buildPasswordResetUrl(username, this.passwordManagementService, this.casProperties);
        LOGGER.debug("Generated password reset URL [{}]; Link is only active for the next [{}] minute(s)", (Object)url, (Object)Float.valueOf(pm.getReset().getExpirationMinutes()));
        if (this.sendPasswordResetEmailToAccount(to, url)) {
            return this.success();
        }
        LOGGER.error("Failed to notify account [{}]", (Object)to);
        return this.error();
    }

    public static String buildPasswordResetUrl(String username, PasswordManagementService passwordManagementService, CasConfigurationProperties casProperties) {
        String token = passwordManagementService.createToken(username);
        return casProperties.getServer().getPrefix().concat("/login?pswdrst=").concat(token);
    }

    protected boolean sendPasswordResetEmailToAccount(String to, String url) {
        EmailProperties reset = this.casProperties.getAuthn().getPm().getReset().getMail();
        String text = String.format(reset.getText(), url);
        return this.communicationsManager.email(text, reset.getFrom(), reset.getSubject(), to, reset.getCc(), reset.getBcc());
    }

    @Generated
    public SendPasswordResetInstructionsAction(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, PasswordManagementService passwordManagementService) {
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
    }
}

