/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.configuration.model.support.redis.RedisTicketRegistryProperties;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.RedisTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CoreTicketUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration(value="redisTicketRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class RedisTicketRegistryConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"redisTicketConnectionFactory"})
    @Bean
    public RedisConnectionFactory redisTicketConnectionFactory() {
        RedisTicketRegistryProperties redis = this.casProperties.getTicket().getRegistry().getRedis();
        return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis);
    }

    @Bean
    @ConditionalOnMissingBean(name={"ticketRedisTemplate"})
    public RedisTemplate<String, Ticket> ticketRedisTemplate() {
        return RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)this.redisTicketConnectionFactory());
    }

    @Bean
    public TicketRegistry ticketRegistry() {
        RedisTicketRegistryProperties redis = this.casProperties.getTicket().getRegistry().getRedis();
        RedisTicketRegistry r = new RedisTicketRegistry(this.ticketRedisTemplate());
        r.setCipherExecutor(CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)redis.getCrypto(), (String)"redis"));
        return r;
    }
}

