/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;

public class RedisTicketRegistry
extends AbstractTicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisTicketRegistry.class);
    private static final String CAS_TICKET_PREFIX = "CAS_TICKET:";
    private static final long SCAN_COUNT = 100L;
    private final RedisTemplate<String, Ticket> client;

    private static Long getTimeout(Ticket ticket) {
        Long ttl = ticket.getExpirationPolicy().getTimeToLive();
        if (ttl <= 0L) {
            return 1L;
        }
        return ttl;
    }

    private static String getTicketRedisKey(String ticketId) {
        return CAS_TICKET_PREFIX + ticketId;
    }

    private static String getPatternTicketRedisKey() {
        return "CAS_TICKET:*";
    }

    public long deleteAll() {
        Set redisKeys = this.client.keys((Object)RedisTicketRegistry.getPatternTicketRedisKey());
        if (redisKeys == null) {
            LOGGER.warn("Unable to locate tickets via redis key");
            return 0L;
        }
        int size = redisKeys.size();
        this.client.delete((Collection)redisKeys);
        return size;
    }

    public boolean deleteSingleTicket(String ticketId) {
        try {
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticketId);
            this.client.delete((Object)redisKey);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Ticket not found or is already removed. Failed deleting [{}]", (Object)ticketId, (Object)e);
            return false;
        }
    }

    public void addTicket(Ticket ticket) {
        try {
            LOGGER.debug("Adding ticket [{}]", (Object)ticket);
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticket.getId());
            Ticket encodeTicket = this.encodeTicket(ticket);
            Long timeout = RedisTicketRegistry.getTimeout(ticket);
            this.client.boundValueOps((Object)redisKey).set((Object)encodeTicket, timeout.longValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("Failed to add [{}]", (Object)ticket, (Object)e);
        }
    }

    public Ticket getTicket(String ticketId, Predicate<Ticket> predicate) {
        try {
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticketId);
            Ticket t = (Ticket)this.client.boundValueOps((Object)redisKey).get();
            if (t != null) {
                Ticket result = this.decodeTicket(t);
                if (predicate.test(result)) {
                    return result;
                }
                LOGGER.debug("The condition enforced by the predicate [{}] cannot successfully accept/test the ticket id [{}]", (Object)ticketId, (Object)predicate.getClass().getSimpleName());
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed fetching [{}] ", (Object)ticketId, (Object)e);
        }
        return null;
    }

    public Collection<? extends Ticket> getTickets() {
        try (Stream<? extends Ticket> ticketsStream = this.getTicketsStream();){
            Collection collection = ticketsStream.collect(Collectors.toSet());
            return collection;
        }
    }

    public Stream<? extends Ticket> getTicketsStream() {
        return this.getKeysStream().map(redisKey -> {
            Ticket ticket = (Ticket)this.client.boundValueOps(redisKey).get();
            if (ticket == null) {
                this.client.delete(redisKey);
                return null;
            }
            return ticket;
        }).filter(Objects::nonNull).map(arg_0 -> ((RedisTicketRegistry)this).decodeTicket(arg_0));
    }

    public Ticket updateTicket(Ticket ticket) {
        try {
            LOGGER.debug("Updating ticket [{}]", (Object)ticket);
            Ticket encodeTicket = this.encodeTicket(ticket);
            String redisKey = RedisTicketRegistry.getTicketRedisKey(ticket.getId());
            LOGGER.debug("Fetched redis key [{}] for ticket [{}]", (Object)redisKey, (Object)ticket);
            Long timeout = RedisTicketRegistry.getTimeout(ticket);
            this.client.boundValueOps((Object)redisKey).set((Object)encodeTicket, timeout.longValue(), TimeUnit.SECONDS);
            return encodeTicket;
        }
        catch (Exception e) {
            LOGGER.error("Failed to update [{}]", (Object)ticket, (Object)e);
            return null;
        }
    }

    private Stream<String> getKeysStream() {
        Cursor cursor = this.client.getConnectionFactory().getConnection().scan(ScanOptions.scanOptions().match(RedisTicketRegistry.getPatternTicketRedisKey()).count(100L).build());
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor, 16), false).map(key -> (String)this.client.getKeySerializer().deserialize(key)).collect(Collectors.toSet()).stream().onClose(() -> {
            try {
                cursor.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close Redis connection", (Throwable)e);
            }
        });
    }

    @Generated
    public RedisTicketRegistry(RedisTemplate<String, Ticket> client) {
        this.client = client;
    }
}

