/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;

public class StructureUtil {
    public static List<String> getTargets(IProgramElement node, IRelationship.Kind kind) {
        return StructureUtil.getTargets(node, kind, null);
    }

    public static List<String> getTargets(IProgramElement node, IRelationship.Kind kind, String relName) {
        ArrayList<IRelationship> relations = new ArrayList<IRelationship>();
        List<IRelationship> rels = node.getModel().getRelationshipMap().get(node);
        if (rels != null) {
            relations.addAll(rels);
        }
        for (IProgramElement child : node.getChildren()) {
            List<IRelationship> childRelations;
            if (node.getKind().isType() && !child.getKind().equals(IProgramElement.Kind.CODE) || (childRelations = node.getModel().getRelationshipMap().get(child)) == null) continue;
            for (IRelationship rel : childRelations) {
                if (relations.contains(rel)) continue;
                relations.add(rel);
            }
        }
        if (relations == null || relations.isEmpty()) {
            return null;
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (IRelationship rtn : relations) {
            if (!rtn.getKind().equals(kind) || (relName == null || !relName.equals(rtn.getName())) && relName != null) continue;
            List<String> targs = rtn.getTargets();
            for (String element : targs) {
                if (targets.contains(element)) continue;
                targets.add(element);
            }
        }
        return targets;
    }

    static List<IProgramElement> getDeclareInterTypeTargets(IProgramElement node, IProgramElement.Kind kind) {
        ArrayList<IProgramElement> targets = new ArrayList<IProgramElement>();
        List<String> stringTargets = StructureUtil.getTargets(node, IRelationship.Kind.DECLARE_INTER_TYPE);
        if (stringTargets == null) {
            return null;
        }
        for (String element : stringTargets) {
            IProgramElement ipe = node.getModel().getHierarchy().findElementForHandle(element);
            if (ipe == null || !ipe.getKind().equals(kind)) continue;
            targets.add(ipe);
        }
        return targets;
    }

    public static List<String> getDeclareTargets(IProgramElement node) {
        List<IRelationship> relations = node.getModel().getRelationshipMap().get(node);
        List<String> targets = null;
        if (relations == null) {
            return null;
        }
        for (IRelationship rtn : relations) {
            if (!rtn.getKind().isDeclareKind()) continue;
            targets = rtn.getTargets();
        }
        return targets;
    }

    public static String getPackageDeclarationFromFile(AsmManager model, File file) {
        IProgramElement fileNode = model.getHierarchy().findElementForSourceFile(file.getAbsolutePath());
        String packageName = fileNode.getChildren().get(0).getPackageName();
        return packageName;
    }

    public static String genSignature(IProgramElement node) {
        StringBuffer sb = new StringBuffer();
        String accessibility = node.getAccessibility().toString();
        if (!accessibility.equals("package")) {
            sb.append(accessibility);
            sb.append(' ');
        }
        String modifiers = "";
        Iterator<IProgramElement.Modifiers> modIt = node.getModifiers().iterator();
        while (modIt.hasNext()) {
            modifiers = modifiers + modIt.next() + " ";
        }
        if (node.getKind().equals(IProgramElement.Kind.METHOD) || node.getKind().equals(IProgramElement.Kind.FIELD)) {
            sb.append(node.getCorrespondingType());
            sb.append(' ');
        }
        if (node.getKind().equals(IProgramElement.Kind.CLASS)) {
            sb.append("class ");
        } else if (node.getKind().equals(IProgramElement.Kind.INTERFACE)) {
            sb.append("interface ");
        }
        sb.append(node.getName());
        if (node.getParameterTypes() != null) {
            sb.append('(');
            for (int i = 0; i < node.getParameterTypes().size(); ++i) {
                sb.append(String.valueOf(node.getParameterTypes().get(i)));
                sb.append(' ');
                sb.append(node.getParameterNames().get(i));
                if (i >= node.getParameterTypes().size() - 1) continue;
                sb.append(", ");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static boolean isAnonymous(IProgramElement node) {
        boolean isIntName = true;
        try {
            Integer.valueOf(node.getName());
        }
        catch (NumberFormatException nfe) {
            isIntName = false;
        }
        return isIntName || node.getName().startsWith("new ");
    }

    public static String translateAjPathName(String path) {
        if (path.endsWith(".aj")) {
            path = path.substring(0, path.lastIndexOf(".aj")) + ".java";
        }
        return path;
    }
}

