/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;

public class ShouldHaveRootCause
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveRootCause(Throwable actualCause, Throwable expectedCause) {
        Preconditions.checkArgument(expectedCause != null, "expected cause should not be null", new Object[0]);
        if (actualCause == null) {
            return new ShouldHaveRootCause(expectedCause);
        }
        if (Objects.areEqual(actualCause.getMessage(), expectedCause.getMessage())) {
            return new ShouldHaveRootCause(actualCause, expectedCause.getClass());
        }
        if (Objects.areEqual(actualCause.getClass(), expectedCause.getClass())) {
            return new ShouldHaveRootCause(actualCause, expectedCause.getMessage());
        }
        return new ShouldHaveRootCause(actualCause, expectedCause);
    }

    private ShouldHaveRootCause(Throwable actualCause, Throwable expectedCause) {
        super("%nExpecting a root cause with type:%n  <%s>%nand message:%n  <%s>%nbut type was:%n  <%s>%nand message was:%n  <%s>.", expectedCause.getClass().getName(), expectedCause.getMessage(), actualCause.getClass().getName(), actualCause.getMessage());
    }

    private ShouldHaveRootCause(Throwable expectedCause) {
        super("%nExpecting a root cause with type:%n  <%s>%nand message:%n  <%s>%nbut actual had no root cause.", expectedCause.getClass().getName(), expectedCause.getMessage());
    }

    private ShouldHaveRootCause(Throwable actualCause, Class<? extends Throwable> expectedCauseClass) {
        super("%nExpecting a root cause with type:%n  <%s>%nbut type was:%n  <%s>.", expectedCauseClass.getName(), actualCause.getClass().getName());
    }

    private ShouldHaveRootCause(Throwable actualCause, String expectedCauseMessage) {
        super("%nExpecting a root cause with message:%n  <%s>%nbut message was:%n  <%s>.", expectedCauseMessage, actualCause.getMessage());
    }
}

