/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.IntRecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    public CMSEnvelopedDataGenerator() {
    }

    public CMSEnvelopedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        ByteArrayOutputStream byteArrayOutputStream;
        AlgorithmIdentifier algorithmIdentifier;
        Object object;
        SecretKey secretKey;
        EncryptedContentInfo encryptedContentInfo;
        Provider provider2 = keyGenerator.getProvider();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            encryptedContentInfo = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(string, provider2);
            secretKey = keyGenerator.generateKey();
            object = this.generateParameters(string, secretKey, provider2);
            encryptedContentInfo.init(1, (Key)secretKey, (AlgorithmParameters)object, this.rand);
            if (object == null) {
                object = encryptedContentInfo.getParameters();
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(string, (AlgorithmParameters)object);
            byteArrayOutputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, (Cipher)encryptedContentInfo);
            cMSProcessable.write(cipherOutputStream);
            cipherOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        encryptedContentInfo = this.oldRecipientInfoGenerators.iterator();
        while (encryptedContentInfo.hasNext()) {
            object = (IntRecipientInfoGenerator)encryptedContentInfo.next();
            try {
                aSN1EncodableVector.add((DEREncodable)object.generate(secretKey, this.rand, provider));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        encryptedContentInfo = this.recipientInfoGenerators.iterator();
        while (encryptedContentInfo.hasNext()) {
            object = (RecipientInfoGenerator)encryptedContentInfo.next();
            aSN1EncodableVector.add((DEREncodable)object.generate(new GenericKey(secretKey)));
        }
        encryptedContentInfo = cMSProcessable instanceof CMSTypedData ? new EncryptedContentInfo((DERObjectIdentifier)((CMSTypedData)cMSProcessable).getContentType(), algorithmIdentifier, (ASN1OctetString)bERConstructedOctetString) : new EncryptedContentInfo((DERObjectIdentifier)CMSObjectIdentifiers.data, algorithmIdentifier, (ASN1OctetString)bERConstructedOctetString);
        object = null;
        if (this.unprotectedAttributeGenerator != null) {
            byteArrayOutputStream = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            object = new BERSet(byteArrayOutputStream.toASN1EncodableVector());
        }
        byteArrayOutputStream = new ContentInfo(CMSObjectIdentifiers.envelopedData, (DEREncodable)new EnvelopedData(null, (ASN1Set)new DERSet(aSN1EncodableVector), encryptedContentInfo, (ASN1Set)object));
        return new CMSEnvelopedData((ContentInfo)byteArrayOutputStream);
    }

    private CMSEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        AttributeTable attributeTable;
        RecipientInfoGenerator recipientInfoGenerator;
        Object object;
        if (!this.oldRecipientInfoGenerators.isEmpty()) {
            throw new IllegalStateException("can only use addRecipientGenerator() with this method");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = outputEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CMSException("");
        }
        object = byteArrayOutputStream.toByteArray();
        AlgorithmIdentifier algorithmIdentifier = outputEncryptor.getAlgorithmIdentifier();
        BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString((byte[])object);
        GenericKey genericKey = outputEncryptor.getKey();
        EncryptedContentInfo encryptedContentInfo = this.recipientInfoGenerators.iterator();
        while (encryptedContentInfo.hasNext()) {
            recipientInfoGenerator = (RecipientInfoGenerator)encryptedContentInfo.next();
            aSN1EncodableVector.add((DEREncodable)recipientInfoGenerator.generate(genericKey));
        }
        encryptedContentInfo = new EncryptedContentInfo((DERObjectIdentifier)cMSTypedData.getContentType(), algorithmIdentifier, (ASN1OctetString)bERConstructedOctetString);
        recipientInfoGenerator = null;
        if (this.unprotectedAttributeGenerator != null) {
            attributeTable = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            recipientInfoGenerator = new BERSet(attributeTable.toASN1EncodableVector());
        }
        attributeTable = new ContentInfo(CMSObjectIdentifiers.envelopedData, (DEREncodable)new EnvelopedData(null, (ASN1Set)new DERSet(aSN1EncodableVector), encryptedContentInfo, (ASN1Set)recipientInfoGenerator));
        return new CMSEnvelopedData((ContentInfo)attributeTable);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string, CMSUtils.getProvider(string2));
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, provider);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string, n, CMSUtils.getProvider(string2));
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(n, this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, provider);
    }

    public CMSEnvelopedData generate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputEncryptor);
    }
}

