// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avcodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;

import static org.bytedeco.ffmpeg.global.avcodec.*;


/**
 * \addtogroup lavc_core
 * \{
 */

/**
 * This struct describes the properties of a single codec described by an
 * AVCodecID.
 * @see avcodec_descriptor_get()
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avcodec.class)
public class AVCodecDescriptor extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVCodecDescriptor() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVCodecDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVCodecDescriptor(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVCodecDescriptor position(long position) {
        return (AVCodecDescriptor)super.position(position);
    }
    @Override public AVCodecDescriptor getPointer(long i) {
        return new AVCodecDescriptor((Pointer)this).offsetAddress(i);
    }

    public native @Cast("AVCodecID") int id(); public native AVCodecDescriptor id(int setter);
    public native @Cast("AVMediaType") int type(); public native AVCodecDescriptor type(int setter);
    /**
     * Name of the codec described by this descriptor. It is non-empty and
     * unique for each codec descriptor. It should contain alphanumeric
     * characters and '_' only.
     */
    public native @Cast("const char*") BytePointer name(); public native AVCodecDescriptor name(BytePointer setter);
    /**
     * A more descriptive name for this codec. May be NULL.
     */
    public native @Cast("const char*") BytePointer long_name(); public native AVCodecDescriptor long_name(BytePointer setter);
    /**
     * Codec properties, a combination of AV_CODEC_PROP_* flags.
     */
    public native int props(); public native AVCodecDescriptor props(int setter);
    /**
     * MIME type(s) associated with the codec.
     * May be NULL; if not, a NULL-terminated array of MIME types.
     * The first item is always non-NULL and is the preferred MIME type.
     */
    @MemberGetter public native @Cast("const char*") BytePointer mime_types(int i);
    @MemberGetter public native @Cast("const char*const*") PointerPointer mime_types();
    /**
     * If non-NULL, an array of profiles recognized for this codec.
     * Terminated with FF_PROFILE_UNKNOWN.
     */
    public native @Const AVProfile profiles(); public native AVCodecDescriptor profiles(AVProfile setter);
}
