/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class BooleanRawIndexer
extends BooleanIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected BooleanPointer pointer;
    final long base;
    final long size;

    public BooleanRawIndexer(BooleanPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public BooleanRawIndexer(BooleanPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 1L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public boolean get(long i) {
        return RAW.getBoolean(this.base + BooleanRawIndexer.checkIndex(i, this.size) * 1L);
    }

    @Override
    public BooleanIndexer get(long i, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public boolean get(long i, long j) {
        return this.get(i * this.strides[0] + j);
    }

    @Override
    public BooleanIndexer get(long i, long j, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public boolean get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public boolean get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public BooleanIndexer get(long[] indices, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public BooleanIndexer put(long i, boolean b) {
        RAW.putBoolean(this.base + BooleanRawIndexer.checkIndex(i, this.size) * 1L, b);
        return this;
    }

    @Override
    public BooleanIndexer put(long i, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public BooleanIndexer put(long i, long j, boolean b) {
        this.put(i * this.strides[0] + j, b);
        return this;
    }

    @Override
    public BooleanIndexer put(long i, long j, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public BooleanIndexer put(long i, long j, long k, boolean b) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, b);
        return this;
    }

    @Override
    public BooleanIndexer put(long[] indices, boolean b) {
        this.put(this.index(indices), b);
        return this;
    }

    @Override
    public BooleanIndexer put(long[] indices, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, b[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

