/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.jdbc.RecoveredResource;
import org.bytesoft.bytejta.supports.resource.RemoteResourceDescriptor;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytetcc.supports.resource.LocalResourceCleaner;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableInvocation;
import org.bytesoft.compensable.CompensableTransaction;
import org.bytesoft.compensable.ContainerContext;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.archive.CompensableArchive;
import org.bytesoft.compensable.archive.TransactionArchive;
import org.bytesoft.compensable.logging.CompensableLogger;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.supports.TransactionListener;
import org.bytesoft.transaction.supports.TransactionListenerAdapter;
import org.bytesoft.transaction.supports.TransactionResourceListener;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.bytesoft.transaction.supports.serialize.XAResourceDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompensableTransactionImpl
extends TransactionListenerAdapter
implements CompensableTransaction {
    static final Logger logger = LoggerFactory.getLogger(CompensableTransactionImpl.class);
    private final TransactionContext transactionContext;
    private final List<CompensableArchive> archiveList = new ArrayList<CompensableArchive>();
    private final Map<String, XAResourceArchive> resourceMap = new HashMap<String, XAResourceArchive>();
    private final List<XAResourceArchive> resourceList = new ArrayList<XAResourceArchive>();
    private final Map<String, XAResourceArchive> applicationMap = new HashMap<String, XAResourceArchive>();
    private final Map<Thread, Transaction> transactionMap = new ConcurrentHashMap<Thread, Transaction>(4);
    private CompensableBeanFactory beanFactory;
    private int transactionVote;
    private int transactionStatus = 0;
    private transient Boolean positive;
    private transient CompensableArchive archive;
    private final transient List<CompensableArchive> currentArchiveList = new ArrayList<CompensableArchive>();
    private final transient Map<Xid, List<CompensableArchive>> archiveMap = new HashMap<Xid, List<CompensableArchive>>();
    private boolean participantStickyRequired;
    private Map<String, Serializable> variables = new HashMap<String, Serializable>();
    private Thread currentThread;
    private final Lock lock = new ReentrantLock();
    private transient Exception createdAt;

    public CompensableTransactionImpl(TransactionContext txContext) {
        this.transactionContext = txContext;
    }

    @Override
    public TransactionArchive getTransactionArchive() {
        TransactionArchive transactionArchive = new TransactionArchive();
        transactionArchive.setVariables(this.variables);
        transactionArchive.setCoordinator(this.transactionContext.isCoordinator());
        transactionArchive.setPropagated(this.transactionContext.isPropagated());
        transactionArchive.setCompensable(this.transactionContext.isCompensable());
        transactionArchive.setCompensableStatus(this.transactionStatus);
        transactionArchive.setVote(this.transactionVote);
        transactionArchive.setXid((Xid)this.transactionContext.getXid());
        transactionArchive.getRemoteResources().addAll(this.resourceList);
        transactionArchive.getCompensableResourceList().addAll(this.archiveList);
        transactionArchive.setPropagatedBy(this.transactionContext.getPropagatedBy());
        return transactionArchive;
    }

    public synchronized void participantCommit(boolean opc) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, CommitRequiredException, SystemException {
        this.recoverIfNecessary();
        if (this.transactionStatus != 3) {
            this.fireCommit();
        }
    }

    public synchronized void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.transactionStatus == 0) {
            this.fireCommit();
        } else {
            if (this.transactionStatus == 1) {
                this.fireRollback();
                throw new HeuristicRollbackException();
            }
            if (this.transactionStatus == 4) {
                throw new RollbackException();
            }
            if (this.transactionStatus == 3) {
                logger.debug("Current transaction has already been committed.");
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private void fireCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        this.transactionContext.setCompensating(true);
        this.transactionStatus = 8;
        compensableLogger.updateTransaction(this.getTransactionArchive());
        SystemException systemEx = null;
        try {
            this.fireNativeParticipantConfirm();
        }
        catch (SystemException ex) {
            systemEx = ex;
            logger.info("{}| confirm native branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
        }
        catch (RuntimeException ex) {
            systemEx = new SystemException();
            systemEx.initCause((Throwable)ex);
            logger.info("{}| confirm native branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
        }
        try {
            this.fireRemoteParticipantConfirm();
        }
        catch (HeuristicMixedException ex) {
            logger.info("{}| confirm remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            throw ex;
        }
        catch (HeuristicRollbackException ex) {
            logger.info("{}| confirm remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            throw ex;
        }
        catch (SystemException ex) {
            logger.info("{}| confirm remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.info("{}| confirm remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            throw ex;
        }
        if (systemEx != null) {
            throw systemEx;
        }
        this.transactionStatus = 3;
        compensableLogger.updateTransaction(this.getTransactionArchive());
        logger.info("{}| compensable transaction committed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()));
    }

    public synchronized void recoveryCommit() throws CommitRequiredException, SystemException {
        this.recoverIfNecessary();
        try {
            this.fireCommit();
        }
        catch (SecurityException ex) {
            logger.error("{}| confirm native/remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
        catch (RollbackException ex) {
            logger.error("{}| confirm native/remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
        catch (HeuristicMixedException ex) {
            logger.error("{}| confirm native/remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
        catch (HeuristicRollbackException ex) {
            logger.error("{}| confirm native/remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNativeParticipantConfirm() throws SystemException {
        boolean errorExists = false;
        ContainerContext container = this.beanFactory.getContainerContext();
        for (int i = this.archiveList.size() - 1; i >= 0; --i) {
            CompensableArchive current = this.archiveList.get(i);
            if (current.isConfirmed()) continue;
            try {
                this.positive = true;
                this.archive = current;
                CompensableInvocation invocation = current.getCompensable();
                if (invocation == null) {
                    errorExists = true;
                    logger.error("{}| error occurred while confirming service: {}, please check whether the params of method(compensable-service) supports serialization.", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ByteUtils.byteArrayToString((byte[])current.getIdentifier().getGlobalTransactionId()));
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)invocation.getConfirmableKey())) {
                    container.confirm(invocation);
                    continue;
                }
                current.setConfirmed(true);
                logger.info("{}| confirm: identifier= {}, resourceKey= {}, resourceXid= {}.", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])current.getIdentifier().getGlobalTransactionId()), current.getCompensableResourceKey(), current.getCompensableXid()});
                continue;
            }
            catch (RuntimeException rex) {
                errorExists = true;
                logger.error("{}| error occurred while confirming service: {}", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), current, rex});
                continue;
            }
            finally {
                this.archive = null;
                this.positive = null;
            }
        }
        if (errorExists) {
            throw new SystemException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fireRemoteParticipantConfirm() throws HeuristicMixedException, HeuristicRollbackException, CommitRequiredException, SystemException {
        committedExists = false;
        rolledbackExists = false;
        unFinishExists = false;
        errorExists = false;
        block16: for (i = 0; i < this.resourceList.size(); ++i) {
            current = this.resourceList.get(i);
            if (current.isCommitted()) {
                committedExists = true;
                continue;
            }
            if (current.isRolledback()) {
                rolledbackExists = true;
                continue;
            }
            if (current.isReadonly()) continue;
            transactionLogger = this.beanFactory.getCompensableLogger();
            xidFactory = this.beanFactory.getCompensableXidFactory();
            branchXid = (TransactionXid)current.getXid();
            globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
            try {
                current.commit((Xid)globalXid, true);
                committedExists = true;
                current.setCommitted(true);
                current.setCompleted(true);
                CompensableTransactionImpl.logger.info("{}| confirm remote branch: {}", (Object)ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), (Object)current.getDescriptor().getIdentifier());
                continue;
            }
            catch (XAException ex) {
                switch (ex.errorCode) {
                    case 7: {
                        committedExists = true;
                        current.setHeuristic(true);
                        current.setCommitted(true);
                        current.setCompleted(true);
                        ** break;
lbl33:
                        // 1 sources

                        continue block16;
                    }
                    case 5: {
                        committedExists = true;
                        rolledbackExists = true;
                        current.setHeuristic(true);
                        current.setCommitted(true);
                        current.setRolledback(true);
                        current.setCompleted(true);
                        CompensableTransactionImpl.logger.error("{}| error occurred while confirming remote branch: {}, transaction has been completed!", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current.getDescriptor().getIdentifier(), ex});
                        ** break;
lbl43:
                        // 1 sources

                        continue block16;
                    }
                    case 6: {
                        rolledbackExists = true;
                        current.setHeuristic(true);
                        current.setRolledback(true);
                        current.setCompleted(true);
                        ** break;
lbl50:
                        // 1 sources

                        continue block16;
                    }
                    case 8: {
                        unFinishExists = true;
                        current.setHeuristic(true);
                        CompensableTransactionImpl.logger.warn("{}| error occurred while confirming remote branch: {}, transaction may has been completd!", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current.getDescriptor().getIdentifier(), ex});
                        ** break;
lbl56:
                        // 1 sources

                        continue block16;
                    }
                    case -7: {
                        unFinishExists = true;
                        CompensableTransactionImpl.logger.warn("{}| error occurred while confirming remote branch: {}, the remote branch is unreachable!", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current.getDescriptor().getIdentifier(), ex});
                        ** break;
lbl61:
                        // 1 sources

                        continue block16;
                    }
                    case -4: {
                        committedExists = true;
                        current.setCommitted(true);
                        current.setCompleted(true);
                        ** break;
lbl67:
                        // 1 sources

                        continue block16;
                    }
                    case -6: 
                    case -5: 
                    case -3: {
                        errorExists = true;
                        CompensableTransactionImpl.logger.warn("{}| error occurred while confirming remote branch: {}!", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current.getDescriptor().getIdentifier(), ex});
                        ** break;
lbl72:
                        // 1 sources

                        continue block16;
                    }
                    default: {
                        rolledbackExists = true;
                        current.setRolledback(true);
                        current.setCompleted(true);
                        CompensableTransactionImpl.logger.error("{}| error occurred while confirming remote branch: {}, transaction has been rolled back!", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current.getDescriptor().getIdentifier(), ex});
                        continue block16;
                    }
                }
            }
            catch (RuntimeException rex) {
                errorExists = true;
                CompensableTransactionImpl.logger.warn("{}| error occurred while confirming remote branch: {}!", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current.getDescriptor().getIdentifier(), rex});
                continue;
            }
            finally {
                if (current.isCompleted()) {
                    transactionLogger.updateCoordinator(current);
                }
            }
        }
        if (committedExists && rolledbackExists) {
            throw new HeuristicMixedException();
        }
        if (unFinishExists) {
            throw new CommitRequiredException();
        }
        if (errorExists) {
            throw new SystemException();
        }
        if (rolledbackExists) {
            throw new HeuristicRollbackException();
        }
    }

    public int participantPrepare() throws RollbackRequiredException, CommitRequiredException {
        throw new RuntimeException("Not supported!");
    }

    private void markCurrentBranchTransactionRollbackIfNecessary() {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>(this.transactionMap.values());
        boolean recoveried = this.transactionContext.isRecoveried();
        if (!recoveried && !transactions.isEmpty()) {
            for (int i = 0; i < transactions.size(); ++i) {
                Transaction branch = (Transaction)transactions.get(i);
                try {
                    branch.setRollbackOnly();
                    continue;
                }
                catch (IllegalStateException ex) {
                    logger.info("The local transaction is not active.", (Throwable)ex);
                    continue;
                }
                catch (SystemException ex) {
                    logger.warn("The local transaction is not active.", (Throwable)ex);
                    continue;
                }
                catch (RuntimeException ex) {
                    logger.warn("The local transaction is not active.", (Throwable)ex);
                }
            }
        }
    }

    public synchronized void participantRollback() throws IllegalStateException, SystemException {
        this.recoverIfNecessary();
        if (this.transactionStatus != 4) {
            this.fireRollback();
        }
    }

    public synchronized void rollback() throws IllegalStateException, SystemException {
        if (this.transactionStatus == 5) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 6) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 3) {
            throw new IllegalStateException();
        }
        if (this.transactionStatus == 4) {
            logger.debug("Current transaction has already been rolled back.");
        } else {
            this.fireRollback();
        }
    }

    private void fireRollback() throws IllegalStateException, SystemException {
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        this.transactionStatus = 9;
        this.markCurrentBranchTransactionRollbackIfNecessary();
        this.transactionContext.setCompensating(true);
        compensableLogger.updateTransaction(this.getTransactionArchive());
        SystemException systemEx = null;
        try {
            this.fireNativeParticipantCancel();
        }
        catch (SystemException ex) {
            systemEx = ex;
            logger.info("{}| cancel native branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
        }
        catch (RuntimeException ex) {
            systemEx = new SystemException();
            systemEx.initCause((Throwable)ex);
            logger.info("{}| cancel native branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
        }
        try {
            this.fireRemoteParticipantCancel();
        }
        catch (SystemException ex) {
            logger.info("{}| cancel remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.info("{}| cancel remote branchs failed!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ex);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)ex);
            throw sysEx;
        }
        if (systemEx != null) {
            throw systemEx;
        }
        this.transactionStatus = 4;
        compensableLogger.updateTransaction(this.getTransactionArchive());
        logger.info("{}| compensable transaction rolled back!", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()));
    }

    public synchronized void recoveryRollback() throws RollbackRequiredException, SystemException {
        this.recoverIfNecessary();
        this.fireRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNativeParticipantCancel() throws SystemException {
        boolean errorExists = false;
        ContainerContext container = this.beanFactory.getContainerContext();
        for (int i = this.archiveList.size() - 1; i >= 0; --i) {
            CompensableArchive current = this.archiveList.get(i);
            if (!current.isTried()) {
                logger.info("{}| The operation in try phase is rolled back, so the cancel operation is ignored, compensable service: {}.", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ByteUtils.byteArrayToString((byte[])current.getIdentifier().getGlobalTransactionId()));
                continue;
            }
            if (current.isCancelled()) continue;
            try {
                this.positive = false;
                this.archive = current;
                CompensableInvocation invocation = current.getCompensable();
                if (invocation == null) {
                    errorExists = true;
                    logger.error("{}| error occurred while cancelling service: {}, please check whether the params of method(compensable-service) supports serialization.", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ByteUtils.byteArrayToString((byte[])current.getIdentifier().getGlobalTransactionId()));
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)invocation.getCancellableKey())) {
                    container.cancel(invocation);
                    continue;
                }
                current.setCancelled(true);
                logger.info("{}| cancel: identifier= {}, resourceKey= {}, resourceXid= {}.", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])current.getIdentifier().getGlobalTransactionId()), current.getCompensableResourceKey(), current.getCompensableXid()});
                continue;
            }
            catch (RuntimeException rex) {
                errorExists = true;
                logger.error("{}| error occurred while cancelling service: {}", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), current, rex});
                continue;
            }
            finally {
                this.archive = null;
                this.positive = null;
            }
        }
        if (errorExists) {
            throw new SystemException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fireRemoteParticipantCancel() throws RollbackRequiredException, SystemException {
        committedExists = false;
        rolledbackExists = false;
        unFinishExists = false;
        errorExists = false;
        block16: for (i = 0; i < this.resourceList.size(); ++i) {
            current = this.resourceList.get(i);
            if (current.isCommitted()) {
                committedExists = true;
                continue;
            }
            if (current.isRolledback()) {
                rolledbackExists = true;
                continue;
            }
            if (current.isReadonly()) continue;
            transactionLogger = this.beanFactory.getCompensableLogger();
            xidFactory = this.beanFactory.getCompensableXidFactory();
            branchXid = (TransactionXid)current.getXid();
            globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
            try {
                current.rollback((Xid)globalXid);
                rolledbackExists = true;
                current.setRolledback(true);
                current.setCompleted(true);
                CompensableTransactionImpl.logger.info("{}| cancel remote branch: {}", (Object)ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), (Object)current.getDescriptor().getIdentifier());
                continue;
            }
            catch (XAException xaex) {
                switch (xaex.errorCode) {
                    case 8: {
                        unFinishExists = true;
                        current.setHeuristic(true);
                        CompensableTransactionImpl.logger.error("{}| error occurred while cancelling remote branch: {}", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current, xaex});
                        ** break;
lbl32:
                        // 1 sources

                        continue block16;
                    }
                    case 5: {
                        committedExists = true;
                        rolledbackExists = true;
                        current.setCommitted(true);
                        current.setRolledback(true);
                        current.setHeuristic(true);
                        current.setCompleted(true);
                        ** break;
lbl41:
                        // 1 sources

                        continue block16;
                    }
                    case 7: {
                        committedExists = true;
                        current.setCommitted(true);
                        current.setHeuristic(true);
                        current.setCompleted(true);
                        ** break;
lbl48:
                        // 1 sources

                        continue block16;
                    }
                    case 6: {
                        rolledbackExists = true;
                        current.setRolledback(true);
                        current.setHeuristic(true);
                        current.setCompleted(true);
                        ** break;
lbl55:
                        // 1 sources

                        continue block16;
                    }
                    case 3: {
                        current.setReadonly(true);
                        current.setCompleted(true);
                        ** break;
lbl60:
                        // 1 sources

                        continue block16;
                    }
                    case -7: {
                        unFinishExists = true;
                        CompensableTransactionImpl.logger.error("{}| error occurred while cancelling remote branch: {}, the remote branch is unreachable!", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current, xaex});
                        ** break;
lbl65:
                        // 1 sources

                        continue block16;
                    }
                    case -4: {
                        rolledbackExists = true;
                        current.setRolledback(true);
                        current.setCompleted(true);
                        ** break;
lbl71:
                        // 1 sources

                        continue block16;
                    }
                    default: {
                        errorExists = true;
                        CompensableTransactionImpl.logger.error("{}| error occurred while cancelling remote branch: {}", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current, xaex});
                        continue block16;
                    }
                }
            }
            catch (RuntimeException rex) {
                errorExists = true;
                CompensableTransactionImpl.logger.error("{}| error occurred while cancelling remote branch: {}", new Object[]{ByteUtils.byteArrayToString((byte[])branchXid.getGlobalTransactionId()), current, rex});
                continue;
            }
            finally {
                if (current.isCompleted()) {
                    transactionLogger.updateCoordinator(current);
                }
            }
        }
        if (committedExists && rolledbackExists) {
            throw new SystemException(5);
        }
        if (unFinishExists) {
            throw new RollbackRequiredException();
        }
        if (errorExists) {
            throw new SystemException(-3);
        }
        if (committedExists) {
            throw new SystemException(7);
        }
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        boolean resourceValid;
        if (this.transactionStatus == 1) {
            throw new RollbackException();
        }
        if (this.transactionStatus != 0) {
            throw new IllegalStateException();
        }
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        if (!RemoteResourceDescriptor.class.isInstance(xaRes)) {
            throw new SystemException("Invalid resource!");
        }
        RemoteResourceDescriptor descriptor = (RemoteResourceDescriptor)xaRes;
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        TransactionXid globalXid = this.transactionContext.getXid();
        TransactionXid branchXid = xidFactory.createBranchXid(globalXid);
        try {
            descriptor.start((Xid)branchXid, 0);
        }
        catch (XAException ex) {
            throw new RollbackException();
        }
        String identifier = descriptor.getIdentifier();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getCompensableCoordinator();
        String self = transactionCoordinator.getIdentifier();
        String parent = String.valueOf(this.transactionContext.getPropagatedBy());
        boolean bl = resourceValid = !StringUtils.equalsIgnoreCase((CharSequence)identifier, (CharSequence)self) && !CommonUtils.instanceEquals((String)parent, (String)identifier);
        if (!resourceValid) {
            logger.warn("Endpoint {} can not be its own remote branch!", (Object)identifier);
            return false;
        }
        XAResourceArchive resourceArchive = this.resourceMap.get(identifier);
        if (resourceArchive == null) {
            resourceArchive = new XAResourceArchive();
            resourceArchive.setXid((Xid)branchXid);
            resourceArchive.setDescriptor((XAResourceDescriptor)descriptor);
            this.resourceList.add(resourceArchive);
            this.resourceMap.put(identifier, resourceArchive);
            compensableLogger.createCoordinator(resourceArchive);
            logger.info("{}| enlist remote resource: {}.", (Object)ByteUtils.byteArrayToString((byte[])globalXid.getGlobalTransactionId()), (Object)identifier);
            return true;
        }
        return false;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        if (RemoteResourceDescriptor.class.isInstance(xaRes)) {
            RemoteResourceDescriptor descriptor = (RemoteResourceDescriptor)xaRes;
            RemoteCoordinator resource = descriptor.getDelegate();
            String identifier = descriptor.getIdentifier();
            RemoteCoordinator transactionCoordinator = this.beanFactory.getCompensableCoordinator();
            String self = transactionCoordinator.getIdentifier();
            String parent = String.valueOf(this.transactionContext.getPropagatedBy());
            if (StringUtils.equalsIgnoreCase((CharSequence)identifier, (CharSequence)self) || CommonUtils.instanceEquals((String)parent, (String)identifier)) {
                return true;
            }
            XAResourceArchive archive = this.resourceMap.get(identifier);
            if (flag == 0x20000000) {
                this.resourceMap.remove(identifier);
                if (archive != null) {
                    this.resourceList.remove(archive);
                }
                compensableLogger.updateTransaction(this.getTransactionArchive());
            } else if (archive != null) {
                this.applicationMap.put(resource.getApplication(), archive);
            }
        }
        return true;
    }

    public void resume() throws SystemException {
        Transaction transaction = this.transactionMap.get(Thread.currentThread());
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid xid = transactionContext.getXid();
        List<CompensableArchive> compensableList = this.archiveMap.remove(xid);
        this.currentArchiveList.clear();
        this.currentArchiveList.addAll(compensableList);
    }

    public void suspend() throws SystemException {
        Transaction transaction = this.transactionMap.get(Thread.currentThread());
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid xid = transactionContext.getXid();
        ArrayList<CompensableArchive> compensableList = new ArrayList<CompensableArchive>();
        compensableList.addAll(this.currentArchiveList);
        this.currentArchiveList.clear();
        this.archiveMap.put((Xid)xid, compensableList);
    }

    @Override
    public void registerCompensable(CompensableInvocation invocation) {
        XidFactory xidFactory = this.beanFactory.getTransactionXidFactory();
        invocation.setEnlisted(true);
        CompensableArchive archive = new CompensableArchive();
        TransactionXid globalXid = xidFactory.createGlobalXid(this.transactionContext.getXid().getGlobalTransactionId());
        TransactionXid branchXid = xidFactory.createBranchXid(globalXid);
        archive.setIdentifier((Xid)branchXid);
        archive.setCompensable(invocation);
        this.archiveList.add(archive);
        this.currentArchiveList.add(archive);
        logger.info("{}| register compensable service: {}.", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ByteUtils.byteArrayToString((byte[])archive.getIdentifier().getGlobalTransactionId()));
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
    }

    public void registerTransactionListener(TransactionListener listener) {
    }

    public void registerTransactionResourceListener(TransactionResourceListener listener) {
    }

    public void onEnlistResource(Xid xid, XAResource xares) {
        String resourceKey = null;
        if (XAResourceDescriptor.class.isInstance(xares)) {
            XAResourceDescriptor descriptor = (XAResourceDescriptor)xares;
            resourceKey = descriptor.getIdentifier();
        } else if (XAResourceArchive.class.isInstance(xares)) {
            XAResourceArchive resourceArchive = (XAResourceArchive)xares;
            XAResourceDescriptor descriptor = resourceArchive.getDescriptor();
            resourceKey = descriptor == null ? null : descriptor.getIdentifier();
        }
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        if (this.transactionContext.isCompensating()) {
            this.archive.setCompensableXid(xid);
            this.archive.setCompensableResourceKey(resourceKey);
            compensableLogger.updateCompensable(this.archive);
        } else {
            for (int i = 0; i < this.currentArchiveList.size(); ++i) {
                CompensableArchive compensableArchive = this.currentArchiveList.get(i);
                compensableArchive.setTransactionXid(xid);
                compensableArchive.setTransactionResourceKey(resourceKey);
                compensableLogger.createCompensable(compensableArchive);
            }
        }
    }

    public void onDelistResource(Xid xid, XAResource xares) {
    }

    public void onCommitSuccess(TransactionXid xid) {
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        if (this.transactionContext.isCompensating()) {
            if (this.positive != null) {
                if (this.positive.booleanValue()) {
                    this.archive.setConfirmed(true);
                    logger.info("{}| confirm: identifier= {}, resourceKey= {}, resourceXid= {}.", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])this.archive.getIdentifier().getGlobalTransactionId()), this.archive.getCompensableResourceKey(), this.archive.getCompensableXid()});
                } else {
                    this.archive.setCancelled(true);
                    logger.info("{}| cancel: identifier= {}, resourceKey= {}, resourceXid= {}.", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])this.archive.getIdentifier().getGlobalTransactionId()), this.archive.getCompensableResourceKey(), this.archive.getCompensableXid()});
                }
            }
            compensableLogger.updateCompensable(this.archive);
        } else if (this.transactionContext.isCoordinator() && !this.transactionContext.isPropagated() && this.transactionContext.getPropagationLevel() == 0) {
            Iterator<CompensableArchive> itr = this.currentArchiveList.iterator();
            while (itr.hasNext()) {
                CompensableArchive compensableArchive = itr.next();
                itr.remove();
                compensableArchive.setTried(true);
                logger.info("{}| try: identifier= {}, resourceKey= {}, resourceXid= {}.", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])compensableArchive.getIdentifier().getGlobalTransactionId()), compensableArchive.getTransactionResourceKey(), compensableArchive.getTransactionXid()});
            }
            TransactionArchive transactionArchive = this.getTransactionArchive();
            transactionArchive.setCompensableStatus(8);
            compensableLogger.updateTransaction(transactionArchive);
            logger.info("{}| try completed.", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()));
        } else {
            Iterator<CompensableArchive> itr = this.currentArchiveList.iterator();
            while (itr.hasNext()) {
                CompensableArchive compensableArchive = itr.next();
                itr.remove();
                compensableArchive.setTried(true);
                compensableLogger.updateCompensable(compensableArchive);
                logger.info("{}| try: identifier= {}, resourceKey= {}, resourceXid= {}.", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])compensableArchive.getIdentifier().getGlobalTransactionId()), compensableArchive.getTransactionResourceKey(), compensableArchive.getTransactionXid()});
            }
        }
    }

    public void recoverIfNecessary() throws SystemException {
        if (this.transactionContext.isRecoveried()) {
            this.recover();
        }
    }

    public synchronized void recover() throws SystemException {
        if (this.transactionStatus == 2 || this.transactionStatus == 8) {
            this.recoverNativeResource(true);
            this.recoverRemoteResource(true);
        } else if (this.transactionStatus == 7 || this.transactionStatus == 9) {
            this.recoverNativeResource(false);
            this.recoverRemoteResource(false);
        }
    }

    private void recoverNativeResource(boolean positiveFlag) throws SystemException {
        XAResourceDeserializer resourceDeserializer = this.beanFactory.getResourceDeserializer();
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        boolean errorExists = false;
        for (int i = this.archiveList.size() - 1; i >= 0; --i) {
            CompensableArchive current = this.archiveList.get(i);
            String identifier = current.getCompensableResourceKey();
            if (StringUtils.isBlank((CharSequence)identifier) || current.isConfirmed() || current.isCancelled()) continue;
            if (!current.isTried()) {
                logger.info("{}| the try operation is rolled back, so the cancel may be ignored, service: {}.", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), (Object)ByteUtils.byteArrayToString((byte[])current.getIdentifier().getGlobalTransactionId()));
                continue;
            }
            try {
                try {
                    XAResourceDescriptor descriptor = resourceDeserializer.deserialize(identifier);
                    RecoveredResource resource = (RecoveredResource)descriptor.getDelegate();
                    resource.recoverable(current.getCompensableXid());
                    if (positiveFlag) {
                        current.setConfirmed(true);
                    } else {
                        current.setCancelled(true);
                    }
                    compensableLogger.updateCompensable(current);
                }
                catch (XAException xaex) {
                    switch (xaex.errorCode) {
                        case -4: {
                            break;
                        }
                        case -3: {
                            logger.warn("The database table 'bytejta' cannot found, the status of the current branch transaction is unknown!");
                            break;
                        }
                        case -7: {
                            errorExists = true;
                            logger.error("{}| error occurred while recovering the branch transaction service: {}", new Object[]{ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])current.getIdentifier().getGlobalTransactionId()), xaex});
                            break;
                        }
                        default: {
                            logger.error("Illegal state, the status of the current branch transaction is unknown!", (Throwable)xaex);
                            break;
                        }
                    }
                }
                catch (RuntimeException rex) {
                    logger.error("Illegal resources, the status of the current branch transaction is unknown!", (Throwable)rex);
                }
                continue;
            }
            catch (RuntimeException rex) {
                errorExists = true;
                TransactionXid transactionXid = this.transactionContext.getXid();
                logger.error("{}| error occurred while recovering the branch transaction service: {}", new Object[]{ByteUtils.byteArrayToString((byte[])transactionXid.getGlobalTransactionId()), current, rex});
            }
        }
        if (errorExists) {
            throw new SystemException();
        }
    }

    private void recoverRemoteResource(boolean positiveFlag) throws SystemException {
    }

    public synchronized void forgetQuietly() {
        TransactionXid xid = this.transactionContext.getXid();
        try {
            this.forget();
        }
        catch (SystemException ex) {
            logger.error("Error occurred while forgetting transaction: {}", (Object)ByteUtils.byteArrayToInt((byte[])xid.getGlobalTransactionId()), (Object)ex);
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while forgetting transaction: {}", (Object)ByteUtils.byteArrayToInt((byte[])xid.getGlobalTransactionId()), (Object)ex);
        }
    }

    public synchronized void forget() throws SystemException {
        CompensableArchive current;
        LocalResourceCleaner resourceCleaner = this.beanFactory.getLocalResourceCleaner();
        boolean success = true;
        HashMap<Xid, String> xidMap = new HashMap<Xid, String>();
        for (int i = 0; i < this.archiveList.size(); ++i) {
            current = this.archiveList.get(i);
            Xid transactionXid = current.getTransactionXid();
            Xid compensableXid = current.getCompensableXid();
            if (transactionXid != null && current.isTried()) {
                xidMap.put(transactionXid, current.getTransactionResourceKey());
            }
            if (compensableXid == null || !current.isConfirmed() && !current.isCancelled()) continue;
            xidMap.put(compensableXid, current.getCompensableResourceKey());
        }
        for (Map.Entry entry : xidMap.entrySet()) {
            Xid xid = (Xid)entry.getKey();
            String resource = (String)entry.getValue();
            try {
                resourceCleaner.forget(xid, resource);
            }
            catch (RuntimeException rex) {
                success = false;
                logger.error("forget-transaction: error occurred while forgetting xid: {}", (Object)xid, (Object)rex);
            }
        }
        for (int i = 0; i < this.resourceList.size(); ++i) {
            current = this.resourceList.get(i);
            if (current.isCompleted()) continue;
            XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
            TransactionXid branchXid = (TransactionXid)current.getXid();
            TransactionXid globalXid = xidFactory.createGlobalXid(branchXid.getGlobalTransactionId());
            try {
                current.forget((Xid)globalXid);
                continue;
            }
            catch (XAException ex) {
                switch (ex.errorCode) {
                    case -4: {
                        break;
                    }
                    default: {
                        success = false;
                        logger.error("forget-transaction: error occurred while forgetting branch: {}", (Object)branchXid, (Object)ex);
                        break;
                    }
                }
                continue;
            }
            catch (RuntimeException rex) {
                success = false;
                logger.error("forget-transaction: error occurred while forgetting branch: {}", (Object)branchXid, (Object)rex);
            }
        }
        if (!success) {
            throw new SystemException();
        }
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        compensableLogger.deleteTransaction(this.getTransactionArchive());
        compensableRepository.removeErrorTransaction(this.transactionContext.getXid());
        compensableRepository.removeTransaction(this.transactionContext.getXid());
        logger.info("{}| forget transaction.", (Object)ByteUtils.byteArrayToString((byte[])this.transactionContext.getXid().getGlobalTransactionId()));
    }

    public XAResourceDescriptor getResourceDescriptor(String identifier) {
        Transaction transaction = this.transactionMap.get(Thread.currentThread());
        XAResourceDescriptor descriptor = null;
        if (transaction != null) {
            descriptor = transaction.getResourceDescriptor(identifier);
        }
        if (descriptor == null) {
            XAResourceArchive archive = this.resourceMap.get(identifier);
            descriptor = archive == null ? descriptor : archive.getDescriptor();
        }
        return descriptor;
    }

    public XAResourceDescriptor getRemoteCoordinator(String application) {
        XAResourceArchive archive = this.applicationMap.get(application);
        return archive == null ? null : archive.getDescriptor();
    }

    public boolean lock(boolean tryFlag) {
        if (tryFlag) {
            boolean locked = this.lock.tryLock();
            if (locked) {
                this.currentThread = Thread.currentThread();
            }
            return locked;
        }
        this.lock.lock();
        this.currentThread = Thread.currentThread();
        return true;
    }

    public void release() {
        Thread current = Thread.currentThread();
        if (current == this.currentThread) {
            this.currentThread = null;
            this.lock.unlock();
        } else {
            logger.warn("Illegal thread: expect= {}, actual= {}.", (Object)this.currentThread, (Object)current);
        }
    }

    @Override
    public CompensableArchive getCompensableArchive() {
        return this.archive;
    }

    public List<CompensableArchive> getCompensableArchiveList() {
        return this.archiveList;
    }

    public Map<String, XAResourceArchive> getParticipantArchiveMap() {
        return this.resourceMap;
    }

    public List<XAResourceArchive> getParticipantArchiveList() {
        return this.resourceList;
    }

    public Map<String, XAResourceArchive> getApplicationArchiveMap() {
        return this.applicationMap;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        throw new IllegalStateException();
    }

    public void setRollbackOnlyQuietly() {
        throw new IllegalStateException();
    }

    public boolean isLocalTransaction() {
        throw new IllegalStateException();
    }

    public int getStatus() throws SystemException {
        return this.transactionStatus;
    }

    public int getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(int status) {
        this.transactionStatus = status;
    }

    public boolean isTiming() {
        throw new IllegalStateException();
    }

    public void setTransactionTimeout(int seconds) {
        throw new IllegalStateException();
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public Serializable getVariable(String key) {
        return this.variables.get(key);
    }

    public boolean isCurrentCompensableServiceTried() {
        return this.archive.isTried();
    }

    public void setVariable(String key, Serializable variable) {
        this.variables.put(key, variable);
    }

    public boolean isParticipantStickyRequired() {
        return this.participantStickyRequired;
    }

    public void setParticipantStickyRequired(boolean participantStickyRequired) {
        this.participantStickyRequired = participantStickyRequired;
    }

    public Object getTransactionalExtra() {
        return this.transactionMap.get(Thread.currentThread());
    }

    public void setTransactionalExtra(Object transactionalExtra) {
        if (transactionalExtra == null) {
            this.transactionMap.remove(Thread.currentThread());
        } else {
            this.transactionMap.put(Thread.currentThread(), (Transaction)transactionalExtra);
        }
    }

    @Override
    public Transaction getTransaction() {
        return (Transaction)this.getTransactionalExtra();
    }

    public Exception getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Exception createdAt) {
        this.createdAt = createdAt;
    }

    public int getTransactionVote() {
        return this.transactionVote;
    }

    public void setTransactionVote(int transactionVote) {
        this.transactionVote = transactionVote;
    }

    public Map<String, Serializable> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Serializable> variables) {
        this.variables = variables;
    }
}

