/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc;

import javax.inject.Inject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionContext;

public class TransactionCoordinator
implements RemoteCoordinator,
CompensableBeanFactoryAware {
    @Inject
    private CompensableBeanFactory beanFactory;

    public int prepare(Xid xid) throws XAException {
        RemoteCoordinator compensableCoordinator = this.beanFactory.getCompensableCoordinator();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        int formatId = xid.getFormatId();
        if (1207 == formatId) {
            return transactionCoordinator.prepare(xid);
        }
        if (8127 == formatId) {
            return compensableCoordinator.prepare(xid);
        }
        throw new XAException(-5);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        RemoteCoordinator compensableCoordinator = this.beanFactory.getCompensableCoordinator();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        int formatId = xid.getFormatId();
        if (1207 == formatId) {
            transactionCoordinator.commit(xid, onePhase);
        } else if (8127 == formatId) {
            compensableCoordinator.commit(xid, onePhase);
        } else {
            throw new XAException(-5);
        }
    }

    public void rollback(Xid xid) throws XAException {
        RemoteCoordinator compensableCoordinator = this.beanFactory.getCompensableCoordinator();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        int formatId = xid.getFormatId();
        if (1207 == formatId) {
            transactionCoordinator.rollback(xid);
        } else if (8127 == formatId) {
            compensableCoordinator.rollback(xid);
        } else {
            throw new XAException(-5);
        }
    }

    public Xid[] recover(int flags) throws XAException {
        RemoteCoordinator compensableCoordinator = this.beanFactory.getCompensableCoordinator();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        Xid[] jtaXidArray = null;
        try {
            jtaXidArray = transactionCoordinator.recover(flags);
        }
        catch (Exception ex) {
            jtaXidArray = new Xid[]{};
        }
        Xid[] tccXidArray = null;
        try {
            tccXidArray = compensableCoordinator.recover(flags);
        }
        catch (Exception ex) {
            tccXidArray = new Xid[]{};
        }
        Xid[] resultArray = new Xid[jtaXidArray.length + tccXidArray.length];
        System.arraycopy(jtaXidArray, 0, resultArray, 0, jtaXidArray.length);
        System.arraycopy(tccXidArray, 0, resultArray, jtaXidArray.length, tccXidArray.length);
        return resultArray;
    }

    public void forget(Xid xid) throws XAException {
        RemoteCoordinator compensableCoordinator = this.beanFactory.getCompensableCoordinator();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        int formatId = xid.getFormatId();
        if (1207 == formatId) {
            transactionCoordinator.forget(xid);
        } else if (8127 == formatId) {
            compensableCoordinator.forget(xid);
        } else {
            throw new XAException(-5);
        }
    }

    public void forgetQuietly(Xid xid) {
        RemoteCoordinator compensableCoordinator = this.beanFactory.getCompensableCoordinator();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        int formatId = xid.getFormatId();
        if (1207 == formatId) {
            transactionCoordinator.forgetQuietly(xid);
        } else if (8127 == formatId) {
            compensableCoordinator.forgetQuietly(xid);
        }
    }

    public String getApplication() {
        return this.beanFactory.getCompensableCoordinator().getApplication();
    }

    public String getIdentifier() {
        throw new IllegalStateException();
    }

    public void start(Xid xid, int flags) throws XAException {
        throw new XAException(-3);
    }

    public void end(Xid xid, int flags) throws XAException {
        throw new XAException(-3);
    }

    public Transaction start(TransactionContext transactionContext, int flags) throws XAException {
        throw new XAException(-3);
    }

    public Transaction end(TransactionContext transactionContext, int flags) throws XAException {
        throw new XAException(-3);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        throw new XAException(-3);
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        throw new XAException(-3);
    }

    public int getTransactionTimeout() throws XAException {
        throw new XAException(-3);
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

