/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc;

import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableInvocation;
import org.bytesoft.compensable.CompensableInvocationRegistry;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.CompensableTransaction;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManagerImpl
implements TransactionManager,
CompensableBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionManagerImpl.class);
    @Inject
    private CompensableBeanFactory beanFactory;

    public void begin() throws NotSupportedException, SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        CompensableTransaction transaction = compensableManager.getCompensableTransactionQuietly();
        CompensableInvocationRegistry registry = CompensableInvocationRegistry.getInstance();
        CompensableInvocation invocation = registry.getCurrent();
        if (transaction != null) {
            compensableManager.begin();
        } else if (invocation != null) {
            compensableManager.compensableBegin();
        } else {
            transactionManager.begin();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        org.bytesoft.transaction.Transaction transaction = transactionManager.getTransactionQuietly();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        org.bytesoft.transaction.TransactionContext transactionContext = null;
        if (transaction == null && compensable == null) {
            throw new IllegalStateException();
        }
        transactionContext = compensable == null ? transaction.getTransactionContext() : compensable.getTransactionContext();
        if (TransactionContext.class.isInstance(transactionContext)) {
            TransactionContext compensableContext = (TransactionContext)transactionContext;
            if (compensableContext.isRecoveried()) {
                if (!compensableContext.isCompensable()) {
                    throw new IllegalStateException();
                }
                compensableManager.commit();
            } else if (!compensableContext.isCompensable()) {
                transactionManager.commit();
            } else if (compensableContext.isCompensating()) {
                compensableManager.commit();
            } else if (transactionContext.isCoordinator()) {
                if (transactionContext.isPropagated()) {
                    compensableManager.commit();
                } else if (compensableContext.getPropagationLevel() > 0) {
                    compensableManager.commit();
                } else {
                    compensableManager.compensableCommit();
                }
            } else {
                compensableManager.commit();
            }
        } else {
            transactionManager.commit();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        org.bytesoft.transaction.Transaction transaction = transactionManager.getTransactionQuietly();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        org.bytesoft.transaction.TransactionContext transactionContext = null;
        if (transaction == null && compensable == null) {
            throw new IllegalStateException();
        }
        transactionContext = compensable == null ? transaction.getTransactionContext() : compensable.getTransactionContext();
        if (TransactionContext.class.isInstance(transactionContext)) {
            TransactionContext compensableContext = (TransactionContext)transactionContext;
            if (compensableContext.isRecoveried()) {
                if (!compensableContext.isCompensable()) {
                    throw new IllegalStateException();
                }
                compensableManager.rollback();
            } else if (!compensableContext.isCompensable()) {
                transactionManager.rollback();
            } else if (compensableContext.isCompensating()) {
                compensableManager.rollback();
            } else if (compensableContext.isCoordinator()) {
                if (compensableContext.isPropagated()) {
                    compensableManager.rollback();
                } else if (compensableContext.getPropagationLevel() > 0) {
                    compensableManager.rollback();
                } else {
                    compensableManager.compensableRollback();
                }
            } else {
                compensableManager.rollback();
            }
        } else {
            transactionManager.rollback();
        }
    }

    public org.bytesoft.transaction.Transaction suspend() throws SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        org.bytesoft.transaction.TransactionContext transactionContext = null;
        org.bytesoft.transaction.Transaction transaction = transactionManager.getTransactionQuietly();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        if (transaction == null && compensable == null) {
            throw new SystemException();
        }
        transactionContext = compensable == null ? transaction.getTransactionContext() : compensable.getTransactionContext();
        boolean isCompensableTransaction = false;
        if (TransactionContext.class.isInstance(transactionContext)) {
            TransactionContext compensableContext = (TransactionContext)transactionContext;
            isCompensableTransaction = compensableContext.isCompensable();
        }
        return (isCompensableTransaction ? compensableManager : transactionManager).suspend();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        if (!org.bytesoft.transaction.Transaction.class.isInstance(tobj)) {
            throw new InvalidTransactionException();
        }
        org.bytesoft.transaction.Transaction transaction = (org.bytesoft.transaction.Transaction)tobj;
        org.bytesoft.transaction.Transaction compensable = (org.bytesoft.transaction.Transaction)transaction.getTransactionalExtra();
        if (compensable == null) {
            transactionManager.resume(tobj);
        } else {
            TransactionContext compensableContext = (TransactionContext)compensable.getTransactionContext();
            (compensableContext.isCompensable() ? compensableManager : transactionManager).resume(tobj);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        org.bytesoft.transaction.TransactionContext transactionContext = null;
        org.bytesoft.transaction.Transaction transaction = transactionManager.getTransactionQuietly();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        if (transaction == null && compensable == null) {
            throw new IllegalStateException();
        }
        transactionContext = compensable == null ? transaction.getTransactionContext() : compensable.getTransactionContext();
        boolean isCompensableTransaction = false;
        if (TransactionContext.class.isInstance(transactionContext)) {
            TransactionContext compensableContext = (TransactionContext)transactionContext;
            isCompensableTransaction = compensableContext.isCompensable();
        }
        (isCompensableTransaction ? compensableManager : transactionManager).setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        org.bytesoft.transaction.TransactionContext transactionContext = null;
        org.bytesoft.transaction.Transaction transaction = transactionManager.getTransactionQuietly();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        if (transaction == null && compensable == null) {
            throw new IllegalStateException();
        }
        transactionContext = compensable == null ? transaction.getTransactionContext() : compensable.getTransactionContext();
        boolean isCompensableTransaction = false;
        if (TransactionContext.class.isInstance(transactionContext)) {
            TransactionContext compensableContext = (TransactionContext)transactionContext;
            isCompensableTransaction = compensableContext.isCompensable();
        }
        (isCompensableTransaction ? compensableManager : transactionManager).setTransactionTimeout(seconds);
    }

    public org.bytesoft.transaction.Transaction getTransaction(Thread thread) {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        org.bytesoft.transaction.Transaction transaction = transactionManager.getTransaction(thread);
        org.bytesoft.transaction.Transaction compensable = compensableManager.getTransaction(thread);
        if (transaction != null) {
            return transaction;
        }
        if (compensable != null) {
            return ((CompensableTransaction)compensable).getTransaction();
        }
        return null;
    }

    public org.bytesoft.transaction.Transaction getTransaction() throws SystemException {
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        org.bytesoft.transaction.Transaction transaction = transactionManager.getTransactionQuietly();
        CompensableTransaction compensable = compensableManager.getCompensableTransactionQuietly();
        if (transaction != null) {
            return transaction;
        }
        if (compensable != null) {
            return compensable.getTransaction();
        }
        return null;
    }

    public org.bytesoft.transaction.Transaction getTransactionQuietly() {
        try {
            return this.getTransaction();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public int getStatus() throws SystemException {
        org.bytesoft.transaction.Transaction transaction = this.getTransaction();
        return transaction == null ? 6 : transaction.getTransactionStatus();
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public void associateThread(org.bytesoft.transaction.Transaction transaction) {
        throw new IllegalStateException();
    }

    public org.bytesoft.transaction.Transaction desociateThread() {
        throw new IllegalStateException();
    }

    public int getTimeoutSeconds() {
        throw new IllegalStateException();
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        throw new IllegalStateException();
    }
}

