/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.logging.store.VirtualLoggingSystemImpl;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.archive.CompensableArchive;
import org.bytesoft.compensable.archive.TransactionArchive;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.compensable.logging.CompensableLogger;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.logging.LoggingFlushable;
import org.bytesoft.transaction.logging.store.VirtualLoggingListener;
import org.bytesoft.transaction.logging.store.VirtualLoggingRecord;
import org.bytesoft.transaction.recovery.TransactionRecoveryCallback;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleCompensableLogger
extends VirtualLoggingSystemImpl
implements CompensableLogger,
LoggingFlushable,
CompensableBeanFactoryAware,
CompensableEndpointAware {
    static final Logger logger = LoggerFactory.getLogger(SampleCompensableLogger.class);
    @Inject
    private CompensableBeanFactory beanFactory;
    private String endpoint;

    @Override
    public void createTransaction(TransactionArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), (Object)archive);
            this.create(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while creating transaction-archive.", (Throwable)rex);
        }
    }

    @Override
    public void updateTransaction(TransactionArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), (Object)archive);
            this.modify(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying transaction-archive.", (Throwable)rex);
        }
    }

    @Override
    public void deleteTransaction(TransactionArchive archive) {
        try {
            this.delete(archive.getXid());
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while deleting transaction-archive.", (Throwable)rex);
        }
    }

    @Override
    public void createCoordinator(XAResourceArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), (Object)archive);
            this.create(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying resource-archive.", (Throwable)rex);
        }
    }

    @Override
    public void updateCoordinator(XAResourceArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            byte[] byteArray = deserializer.serialize((TransactionXid)archive.getXid(), (Object)archive);
            this.modify(archive.getXid(), byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying resource-archive.", (Throwable)rex);
        }
    }

    @Override
    public void createCompensable(CompensableArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            TransactionXid xid = (TransactionXid)archive.getIdentifier();
            byte[] byteArray = deserializer.serialize(xid, (Object)archive);
            this.create((Xid)xid, byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while creating compensable-archive.", (Throwable)rex);
        }
    }

    @Override
    public void updateCompensable(CompensableArchive archive) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        try {
            TransactionXid xid = (TransactionXid)archive.getIdentifier();
            byte[] byteArray = deserializer.serialize(xid, (Object)archive);
            this.modify((Xid)xid, byteArray);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while modifying compensable-archive.", (Throwable)rex);
        }
    }

    public List<VirtualLoggingRecord> compressIfNecessary(List<VirtualLoggingRecord> recordList) {
        ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        ArrayList<VirtualLoggingRecord> resultList = new ArrayList<VirtualLoggingRecord>();
        HashMap<TransactionXid, TransactionArchive> xidMap = new HashMap<TransactionXid, TransactionArchive>();
        for (int index = 0; recordList != null && index < recordList.size(); ++index) {
            Object element;
            int i;
            TransactionArchive archive;
            VirtualLoggingRecord record = recordList.get(index);
            byte[] byteArray = record.getContent();
            byte[] keyByteArray = new byte[20];
            System.arraycopy(byteArray, 0, keyByteArray, 0, keyByteArray.length);
            byte[] valueByteArray = new byte[byteArray.length - 20 - 1 - 4];
            System.arraycopy(byteArray, 25, valueByteArray, 0, valueByteArray.length);
            TransactionXid xid = xidFactory.createGlobalXid(keyByteArray);
            Object obj = deserializer.deserialize(xid, valueByteArray);
            if (TransactionArchive.class.isInstance(obj)) {
                xidMap.put(xid, (TransactionArchive)((Object)obj));
                continue;
            }
            if (XAResourceArchive.class.isInstance(obj)) {
                archive = (TransactionArchive)((Object)xidMap.get(xid));
                if (archive == null) {
                    logger.error("Error occurred while compressing resource archive: {}", obj);
                    continue;
                }
                XAResourceArchive resourceArchive = (XAResourceArchive)obj;
                boolean matched = false;
                List remoteResources = archive.getRemoteResources();
                for (i = 0; !matched && remoteResources != null && i < remoteResources.size(); ++i) {
                    element = (XAResourceArchive)remoteResources.get(i);
                    if (!resourceArchive.getXid().equals(element.getXid())) continue;
                    matched = true;
                    remoteResources.set(i, resourceArchive);
                }
                if (matched) continue;
                remoteResources.add(resourceArchive);
                continue;
            }
            if (CompensableArchive.class.isInstance(obj)) {
                archive = (TransactionArchive)((Object)xidMap.get(xid));
                if (archive == null) {
                    logger.error("Error occurred while compressing compensable archive: {}", obj);
                    continue;
                }
                List<CompensableArchive> compensables = archive.getCompensableResourceList();
                CompensableArchive resourceArchive = (CompensableArchive)obj;
                boolean matched = false;
                for (i = 0; !matched && compensables != null && i < compensables.size(); ++i) {
                    element = compensables.get(i);
                    if (!resourceArchive.getIdentifier().equals(((CompensableArchive)element).getIdentifier())) continue;
                    matched = true;
                    compensables.set(i, resourceArchive);
                }
                if (matched) continue;
                compensables.add(resourceArchive);
                continue;
            }
            logger.error("unkown resource: {}!", obj);
        }
        for (Map.Entry entry : xidMap.entrySet()) {
            TransactionXid xid = (TransactionXid)entry.getKey();
            TransactionArchive value = (TransactionArchive)((Object)entry.getValue());
            byte[] globalByteArray = xid.getGlobalTransactionId();
            byte[] keyByteArray = new byte[20];
            byte[] valueByteArray = deserializer.serialize(xid, (Object)value);
            byte[] sizeByteArray = ByteUtils.intToByteArray((int)valueByteArray.length);
            System.arraycopy(globalByteArray, 0, keyByteArray, 0, 20);
            byte[] byteArray = new byte[25 + valueByteArray.length];
            System.arraycopy(keyByteArray, 0, byteArray, 0, keyByteArray.length);
            byteArray[keyByteArray.length] = 1;
            System.arraycopy(sizeByteArray, 0, byteArray, 21, sizeByteArray.length);
            System.arraycopy(valueByteArray, 0, byteArray, 25, valueByteArray.length);
            VirtualLoggingRecord record = new VirtualLoggingRecord();
            record.setIdentifier((Xid)xid);
            record.setOperator(1);
            record.setValue(valueByteArray);
            record.setContent(byteArray);
            resultList.add(record);
        }
        return resultList;
    }

    @Override
    public void recover(TransactionRecoveryCallback callback) {
        final HashMap xidMap = new HashMap();
        final ArchiveDeserializer deserializer = this.beanFactory.getArchiveDeserializer();
        final XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        this.traversal(new VirtualLoggingListener(){

            public void recvOperation(VirtualLoggingRecord action) {
                Xid xid = action.getIdentifier();
                int operator = action.getOperator();
                if (3 == operator) {
                    xidMap.remove(xid);
                } else if (!xidMap.containsKey(xid)) {
                    xidMap.put(xid, null);
                }
            }
        });
        this.traversal(new VirtualLoggingListener(){

            public void recvOperation(VirtualLoggingRecord action) {
                Xid xid = action.getIdentifier();
                if (xidMap.containsKey(xid)) {
                    this.execOperation(action);
                }
            }

            public void execOperation(VirtualLoggingRecord action) {
                Xid identifier = action.getIdentifier();
                TransactionXid xid = xidFactory.createGlobalXid(identifier.getGlobalTransactionId());
                Object obj = deserializer.deserialize(xid, action.getValue());
                if (TransactionArchive.class.isInstance(obj)) {
                    TransactionArchive archive = (TransactionArchive)((Object)obj);
                    xidMap.put(identifier, archive);
                } else if (XAResourceArchive.class.isInstance(obj)) {
                    TransactionArchive archive = (TransactionArchive)((Object)xidMap.get(identifier));
                    if (archive == null) {
                        logger.error("Error occurred while recovering resource archive: {}", obj);
                        return;
                    }
                    XAResourceArchive resourceArchive = (XAResourceArchive)obj;
                    boolean matched = false;
                    List remoteResources = archive.getRemoteResources();
                    for (int i = 0; !matched && remoteResources != null && i < remoteResources.size(); ++i) {
                        XAResourceArchive element = (XAResourceArchive)remoteResources.get(i);
                        if (!resourceArchive.getXid().equals(element.getXid())) continue;
                        matched = true;
                        remoteResources.set(i, resourceArchive);
                    }
                    if (!matched) {
                        remoteResources.add(resourceArchive);
                    }
                } else if (CompensableArchive.class.isInstance(obj)) {
                    TransactionArchive archive = (TransactionArchive)((Object)xidMap.get(identifier));
                    if (archive == null) {
                        logger.error("Error occurred while recovering compensable archive: {}", obj);
                        return;
                    }
                    List<CompensableArchive> compensables = archive.getCompensableResourceList();
                    CompensableArchive resourceArchive = (CompensableArchive)obj;
                    boolean matched = false;
                    for (int i = 0; !matched && compensables != null && i < compensables.size(); ++i) {
                        CompensableArchive element = compensables.get(i);
                        if (!resourceArchive.getIdentifier().equals(element.getIdentifier())) continue;
                        matched = true;
                        compensables.set(i, resourceArchive);
                    }
                    if (!matched) {
                        compensables.add(resourceArchive);
                    }
                }
            }
        });
        for (Map.Entry entry : xidMap.entrySet()) {
            TransactionArchive archive = (TransactionArchive)((Object)entry.getValue());
            if (archive == null) continue;
            try {
                callback.recover((org.bytesoft.transaction.archive.TransactionArchive)archive);
            }
            catch (RuntimeException rex) {
                logger.error("Error occurred while recovering transaction(xid= {}).", (Object)archive.getXid(), (Object)rex);
            }
        }
    }

    public File getDefaultDirectory() {
        String address = StringUtils.trimToEmpty((String)this.endpoint);
        File directory = new File(String.format("bytetcc/%s", address.replaceAll("[^a-zA-Z_0-9]", "_")));
        if (!directory.exists()) {
            try {
                directory.mkdirs();
            }
            catch (SecurityException ex) {
                logger.error("Error occurred while creating directory {}!", (Object)directory.getAbsolutePath(), (Object)ex);
            }
        }
        return directory;
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 2;
    }

    public String getLoggingFilePrefix() {
        return "bytetcc-";
    }

    public String getLoggingIdentifier() {
        return "org.bytesoft.bytetcc.logging.sample";
    }

    @Override
    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

