/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.logging.deserializer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.archive.CompensableArchive;
import org.bytesoft.compensable.archive.TransactionArchive;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionArchiveDeserializer
extends org.bytesoft.bytejta.logging.deserializer.TransactionArchiveDeserializer
implements ArchiveDeserializer {
    static final Logger logger = LoggerFactory.getLogger(TransactionArchiveDeserializer.class);
    private ArchiveDeserializer resourceArchiveDeserializer;
    private ArchiveDeserializer compensableArchiveDeserializer;

    public byte[] serialize(TransactionXid xid, Object obj) {
        int i;
        byte[] elementByteArray;
        TransactionArchive archive = (TransactionArchive)((Object)obj);
        String propagatedBy = String.valueOf(archive.getPropagatedBy());
        String[] address = propagatedBy.split("\\s*\\:\\s*");
        byte[] hostByteArray = new byte[4];
        byte[] nameByteArray = new byte[]{};
        byte[] portByteArray = new byte[2];
        if (address.length == 3) {
            String hostStr = address[0];
            String nameStr = address[1];
            String portStr = address[2];
            String[] hostArray = hostStr.split("\\s*\\.\\s*");
            for (int i2 = 0; hostArray.length == 4 && i2 < hostArray.length; ++i2) {
                try {
                    int value = Integer.valueOf(hostArray[i2]);
                    hostByteArray[i2] = (byte)(value - 128);
                    continue;
                }
                catch (RuntimeException rex) {
                    logger.warn(rex.getMessage(), (Throwable)rex);
                }
            }
            nameByteArray = StringUtils.isBlank((CharSequence)nameStr) ? new byte[]{} : nameStr.getBytes();
            try {
                short port = (short)(Integer.valueOf(portStr) - 32768);
                byte[] byteArray = ByteUtils.shortToByteArray((short)port);
                System.arraycopy(byteArray, 0, portByteArray, 0, 2);
            }
            catch (RuntimeException rex) {
                logger.warn(rex.getMessage(), (Throwable)rex);
            }
        }
        List<CompensableArchive> nativeArchiveList = archive.getCompensableResourceList();
        List remoteArchiveList = archive.getRemoteResources();
        int nativeArchiveNumber = nativeArchiveList.size();
        int remoteArchiveNumber = remoteArchiveList.size();
        byte[] varByteArray = null;
        if (archive.getVariables() == null) {
            varByteArray = ByteUtils.shortToByteArray((short)0);
        } else {
            try {
                byte[] textByteArray = CommonUtils.serializeObject((Serializable)((Serializable)((Object)archive.getVariables())));
                byte[] sizeByteArray = ByteUtils.shortToByteArray((short)((short)textByteArray.length));
                varByteArray = new byte[sizeByteArray.length + textByteArray.length];
                System.arraycopy(sizeByteArray, 0, varByteArray, 0, sizeByteArray.length);
                System.arraycopy(textByteArray, 0, varByteArray, sizeByteArray.length, textByteArray.length);
            }
            catch (Exception ex) {
                logger.error("Error occurred while serializing variable: {}", archive.getVariables(), (Object)ex);
                varByteArray = ByteUtils.shortToByteArray((short)0);
            }
        }
        int length = 11 + nameByteArray.length + 2 + varByteArray.length + 2;
        byte[][] nativeByteArray = new byte[nativeArchiveNumber][];
        for (int i3 = 0; i3 < nativeArchiveNumber; ++i3) {
            CompensableArchive compensableArchive = nativeArchiveList.get(i3);
            byte[] compensableByteArray = this.compensableArchiveDeserializer.serialize(xid, (Object)compensableArchive);
            byte[] lengthByteArray = ByteUtils.shortToByteArray((short)((short)compensableByteArray.length));
            elementByteArray = new byte[compensableByteArray.length + 2];
            System.arraycopy(lengthByteArray, 0, elementByteArray, 0, lengthByteArray.length);
            System.arraycopy(compensableByteArray, 0, elementByteArray, 2, compensableByteArray.length);
            nativeByteArray[i3] = elementByteArray;
            length += elementByteArray.length;
        }
        byte[][] remoteByteArray = new byte[remoteArchiveNumber][];
        for (int i4 = 0; i4 < remoteArchiveNumber; ++i4) {
            XAResourceArchive resourceArchive = (XAResourceArchive)remoteArchiveList.get(i4);
            byte[] resourceByteArray = this.resourceArchiveDeserializer.serialize(xid, (Object)resourceArchive);
            byte[] lengthByteArray = ByteUtils.shortToByteArray((short)((short)resourceByteArray.length));
            byte[] elementByteArray2 = new byte[resourceByteArray.length + 2];
            System.arraycopy(lengthByteArray, 0, elementByteArray2, 0, lengthByteArray.length);
            System.arraycopy(resourceByteArray, 0, elementByteArray2, 2, resourceByteArray.length);
            remoteByteArray[i4] = elementByteArray2;
            length += elementByteArray2.length;
        }
        int position = 0;
        byte[] byteArray = new byte[length];
        byteArray[position++] = (byte)archive.getStatus();
        byteArray[position++] = (byte)archive.getVote();
        byteArray[position++] = archive.isCoordinator() ? (byte)1 : 0;
        byteArray[position++] = archive.isPropagated() ? (byte)1 : 0;
        byteArray[position++] = archive.isCompensable() ? (byte)1 : 0;
        byteArray[position++] = (byte)archive.getCompensableStatus();
        System.arraycopy(hostByteArray, 0, byteArray, position, 4);
        position += 4;
        byteArray[position++] = (byte)(nameByteArray.length - 128);
        System.arraycopy(nameByteArray, 0, byteArray, position, nameByteArray.length);
        System.arraycopy(portByteArray, 0, byteArray, position += nameByteArray.length, 2);
        System.arraycopy(varByteArray, 0, byteArray, position += 2, varByteArray.length);
        position += varByteArray.length;
        byteArray[position++] = (byte)nativeArchiveNumber;
        byteArray[position++] = (byte)remoteArchiveNumber;
        for (i = 0; i < nativeArchiveNumber; ++i) {
            elementByteArray = nativeByteArray[i];
            System.arraycopy(elementByteArray, 0, byteArray, position, elementByteArray.length);
            position += elementByteArray.length;
        }
        for (i = 0; i < remoteArchiveNumber; ++i) {
            elementByteArray = remoteByteArray[i];
            System.arraycopy(elementByteArray, 0, byteArray, position, elementByteArray.length);
            position += elementByteArray.length;
        }
        return byteArray;
    }

    public Object deserialize(TransactionXid xid, byte[] array) {
        short length;
        int i;
        ByteBuffer buffer = ByteBuffer.wrap(array);
        TransactionArchive archive = new TransactionArchive();
        archive.setXid((Xid)xid);
        byte status = buffer.get();
        byte vote = buffer.get();
        byte coordinatorValue = buffer.get();
        byte propagatedValue = buffer.get();
        byte compensableValue = buffer.get();
        byte compensableStatus = buffer.get();
        archive.setStatus(status);
        archive.setVote(vote);
        archive.setCoordinator(coordinatorValue != 0);
        archive.setPropagated(propagatedValue != 0);
        archive.setCompensable(compensableValue != 0);
        archive.setCompensableStatus(compensableStatus);
        byte[] hostByteArray = new byte[4];
        buffer.get(hostByteArray);
        StringBuilder ber = new StringBuilder();
        for (int i2 = 0; i2 < hostByteArray.length; ++i2) {
            int value = hostByteArray[i2] + 128;
            if (i2 == 0) {
                ber.append(value);
                continue;
            }
            ber.append(".");
            ber.append(value);
        }
        String host = ber.toString();
        int sizeOfName = 128 + buffer.get();
        byte[] nameByteArray = new byte[sizeOfName];
        buffer.get(nameByteArray);
        String name = new String(nameByteArray);
        int port = 32768 + buffer.getShort();
        archive.setPropagatedBy(String.format("%s:%s:%s", host, name, port));
        short sizeOfVar = buffer.getShort();
        if (sizeOfVar > 0) {
            byte[] varByteArray = new byte[sizeOfVar];
            buffer.get(varByteArray);
            HashMap<String, Serializable> variables = null;
            try {
                variables = (HashMap<String, Serializable>)CommonUtils.deserializeObject((byte[])varByteArray);
            }
            catch (Exception ex) {
                variables = new HashMap<String, Serializable>();
                logger.error("Error occurred while deserializing object: {}", (Object)varByteArray, (Object)ex);
            }
            archive.setVariables(variables);
        }
        int nativeArchiveNumber = buffer.get();
        int remoteArchiveNumber = buffer.get();
        for (i = 0; i < nativeArchiveNumber; ++i) {
            length = buffer.getShort();
            byte[] compensableByteArray = new byte[length];
            buffer.get(compensableByteArray);
            CompensableArchive compensableArchive = (CompensableArchive)this.compensableArchiveDeserializer.deserialize(xid, compensableByteArray);
            archive.getCompensableResourceList().add(compensableArchive);
        }
        for (i = 0; i < remoteArchiveNumber; ++i) {
            length = buffer.getShort();
            byte[] resourceByteArray = new byte[length];
            buffer.get(resourceByteArray);
            XAResourceArchive resourceArchive = (XAResourceArchive)this.resourceArchiveDeserializer.deserialize(xid, resourceByteArray);
            archive.getRemoteResources().add(resourceArchive);
        }
        return archive;
    }

    public ArchiveDeserializer getResourceArchiveDeserializer() {
        return this.resourceArchiveDeserializer;
    }

    public void setResourceArchiveDeserializer(ArchiveDeserializer resourceArchiveDeserializer) {
        this.resourceArchiveDeserializer = resourceArchiveDeserializer;
    }

    public ArchiveDeserializer getCompensableArchiveDeserializer() {
        return this.compensableArchiveDeserializer;
    }

    public void setCompensableArchiveDeserializer(ArchiveDeserializer compensableArchiveDeserializer) {
        this.compensableArchiveDeserializer = compensableArchiveDeserializer;
    }
}

