/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.logging.deserializer;

import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.supports.resource.CommonResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.LocalXAResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.RemoteResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.UnidentifiedResourceDescriptor;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.bytesoft.transaction.supports.serialize.XAResourceDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;

public class XAResourceArchiveDeserializer
implements ArchiveDeserializer,
CompensableBeanFactoryAware {
    private XAResourceDeserializer deserializer;
    @Inject
    private CompensableBeanFactory beanFactory;

    public byte[] serialize(TransactionXid xid, Object obj) {
        XAResourceArchive archive = (XAResourceArchive)obj;
        Xid branchXid = archive.getXid();
        byte[] branchQualifier = branchXid.getBranchQualifier();
        XAResourceDescriptor descriptor = archive.getDescriptor();
        byte[] identifierByteArray = new byte[]{};
        int typeByte = 0;
        if (CommonResourceDescriptor.class.isInstance(descriptor)) {
            typeByte = 1;
            identifierByteArray = descriptor.getIdentifier().getBytes();
        } else if (RemoteResourceDescriptor.class.isInstance(descriptor)) {
            typeByte = 2;
            identifierByteArray = descriptor.getIdentifier().getBytes();
        } else if (LocalXAResourceDescriptor.class.isInstance(descriptor)) {
            typeByte = 3;
            identifierByteArray = descriptor.getIdentifier().getBytes();
        }
        byte branchVote = (byte)archive.getVote();
        byte readonly = archive.isReadonly() ? (byte)1 : 0;
        byte committed = archive.isCommitted() ? (byte)1 : 0;
        byte rolledback = archive.isRolledback() ? (byte)1 : 0;
        byte completed = archive.isCompleted() ? (byte)1 : 0;
        byte heuristic = archive.isHeuristic() ? (byte)1 : 0;
        byte[] byteArray = new byte[22 + identifierByteArray.length + 6];
        System.arraycopy(branchQualifier, 0, byteArray, 0, branchQualifier.length);
        byteArray[20] = typeByte;
        byteArray[21] = (byte)identifierByteArray.length;
        if (identifierByteArray.length > 0) {
            System.arraycopy(identifierByteArray, 0, byteArray, 22, identifierByteArray.length);
        }
        byteArray[22 + identifierByteArray.length] = branchVote;
        byteArray[22 + identifierByteArray.length + 1] = readonly;
        byteArray[22 + identifierByteArray.length + 2] = committed;
        byteArray[22 + identifierByteArray.length + 3] = rolledback;
        byteArray[22 + identifierByteArray.length + 4] = completed;
        byteArray[22 + identifierByteArray.length + 5] = heuristic;
        return byteArray;
    }

    public Object deserialize(TransactionXid xid, byte[] array) {
        ByteBuffer buffer = ByteBuffer.wrap(array);
        XAResourceArchive archive = new XAResourceArchive();
        byte[] branchQualifier = new byte[20];
        buffer.get(branchQualifier);
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        TransactionXid branchXid = xidFactory.createBranchXid(xid, branchQualifier);
        archive.setXid((Xid)branchXid);
        byte resourceType = buffer.get();
        byte length = buffer.get();
        byte[] byteArray = new byte[length];
        buffer.get(byteArray);
        String identifier = new String(byteArray);
        XAResourceDescriptor descriptor = null;
        if (resourceType == 1) {
            archive.setIdentified(true);
            descriptor = this.deserializer.deserialize(identifier);
        } else if (resourceType == 2) {
            archive.setIdentified(true);
            descriptor = this.deserializer.deserialize(identifier);
        } else if (resourceType == 3) {
            archive.setIdentified(true);
            descriptor = this.deserializer.deserialize(identifier);
        } else {
            descriptor = new UnidentifiedResourceDescriptor();
        }
        if (CommonResourceDescriptor.class.isInstance(descriptor)) {
            ((CommonResourceDescriptor)descriptor).setRecoverXid((Xid)branchXid);
        }
        archive.setDescriptor(descriptor);
        byte branchVote = buffer.get();
        byte readonly = buffer.get();
        byte committedValue = buffer.get();
        byte rolledbackValue = buffer.get();
        byte completedValue = buffer.get();
        byte heuristicValue = buffer.get();
        archive.setVote((int)branchVote);
        archive.setReadonly(readonly != 0);
        archive.setCommitted(committedValue != 0);
        archive.setRolledback(rolledbackValue != 0);
        archive.setCompleted(completedValue != 0);
        archive.setHeuristic(heuristicValue != 0);
        return archive;
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public XAResourceDeserializer getDeserializer() {
        return this.deserializer;
    }

    public void setDeserializer(XAResourceDeserializer deserializer) {
        this.deserializer = deserializer;
    }
}

