/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.work;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytetcc.work.CleanupRecord;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupFile
implements CompensableEndpointAware,
CompensableBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(CleanupFile.class);
    static final byte[] IDENTIFIER = "org.bytesoft.bytetcc.resource.cleanup".getBytes();
    static final int CONSTANTS_START_INDEX = IDENTIFIER.length + 2 + 1 + 4 + 4;
    static final int CONSTANTS_RES_ID_MAX_SIZE = 23;
    static final int CONSTANTS_RECORD_SIZE = 63;
    private final String resourceName;
    private CompensableBeanFactory beanFactory;
    private String endpoint;
    private int sizeOfRaf = -1;
    private int endIndex = CONSTANTS_START_INDEX;
    private File directory;
    private RandomAccessFile raf;
    private FileChannel channel;
    private MappedByteBuffer header;
    private final List<CleanupRecord> recordList = new ArrayList<CleanupRecord>();
    private final Map<String, Set<CleanupRecord>> recordMap = new HashMap<String, Set<CleanupRecord>>();

    public CleanupFile(String resourceName) {
        this.resourceName = resourceName;
    }

    public byte initialize(boolean master) {
        if (this.directory == null) {
            String address = StringUtils.trimToEmpty((String)this.endpoint);
            String dirName = address.replaceAll("[^a-zA-Z0-9]", "_");
            this.directory = new File(String.format("bytetcc/%s", dirName));
        }
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new RuntimeException();
        }
        boolean created = false;
        File resource = new File(this.directory, this.resourceName);
        boolean exists = resource.exists();
        if (!exists) {
            try {
                created = resource.createNewFile();
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("Error occurred while creating file: %s.", resource));
            }
            if (!created) {
                throw new RuntimeException();
            }
        }
        try {
            this.raf = new RandomAccessFile(resource, "rw");
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(String.format("File not found: %s.", resource), ex);
        }
        if (created) {
            try {
                this.raf.setLength(CONSTANTS_START_INDEX);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            this.sizeOfRaf = (int)this.raf.length();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.channel = this.raf.getChannel();
        try {
            this.header = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, CONSTANTS_START_INDEX);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.checkIdentifier();
        this.checkVersion();
        byte masterFlag = this.checkMasterFlag(created ? Boolean.valueOf(master) : null);
        this.checkStartIndex();
        this.endIndex = this.checkEndIndex();
        return masterFlag;
    }

    private void checkIdentifier() {
        byte[] array = new byte[IDENTIFIER.length];
        this.header.position(0);
        this.header.get(array);
        if (!Arrays.equals(IDENTIFIER, array)) {
            if (Arrays.equals(new byte[IDENTIFIER.length], array)) {
                this.header.position(0);
                this.header.put(IDENTIFIER);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private void checkVersion() {
        this.header.position(IDENTIFIER.length);
        byte major = this.header.get();
        byte minor = this.header.get();
        if (major != 0 || minor != 2) {
            if (major == 0 && minor == 0) {
                this.header.position(IDENTIFIER.length);
                this.header.put((byte)0);
                this.header.put((byte)2);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private byte checkMasterFlag(Boolean master) {
        this.header.position(IDENTIFIER.length + 2);
        if (master == null) {
            return this.header.get();
        }
        if (master.booleanValue()) {
            this.header.put((byte)1);
            return 1;
        }
        this.header.put((byte)0);
        return 0;
    }

    public void markMaster() {
        this.header.position(IDENTIFIER.length + 2);
        this.header.put((byte)1);
    }

    public void markPrepare() {
        this.header.position(IDENTIFIER.length + 2);
        this.header.put((byte)2);
    }

    public void markSlaver() {
        this.header.position(IDENTIFIER.length + 2);
        this.header.put((byte)0);
    }

    private void checkStartIndex() {
        this.header.position(IDENTIFIER.length + 2 + 1);
        int start = this.header.getInt();
        if (start != IDENTIFIER.length + 2 + 1 + 8) {
            if (start == 0) {
                this.header.position(IDENTIFIER.length + 2 + 1);
                this.header.putInt(IDENTIFIER.length + 2 + 1 + 8);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private int checkEndIndex() {
        this.header.position(IDENTIFIER.length + 2 + 1 + 4);
        int end = this.header.getInt();
        if (end == 0) {
            this.header.position(IDENTIFIER.length + 2 + 1 + 4);
            this.header.putInt(IDENTIFIER.length + 2 + 1 + 8);
            return IDENTIFIER.length + 2 + 1 + 8;
        }
        if (end < CONSTANTS_START_INDEX) {
            throw new IllegalStateException();
        }
        return end;
    }

    public void startupRecover() throws RuntimeException {
        XidFactory xidFactory = this.beanFactory.getTransactionXidFactory();
        LinkedList<CleanupRecord> removedList = new LinkedList<CleanupRecord>();
        CleanupRecord lastEnabledRecord = null;
        int current = CONSTANTS_START_INDEX;
        while (current < this.endIndex) {
            ByteBuffer buffer = ByteBuffer.allocate(64);
            try {
                this.channel.position(current);
                this.channel.read(buffer);
                buffer.flip();
            }
            catch (Exception ex) {
                logger.error("Error occurred while accessing file {}!", (Object)this.resourceName, (Object)ex);
                throw new IllegalStateException();
            }
            byte[] resourceByteArray = new byte[23];
            byte[] globalByteArray = new byte[20];
            byte[] branchByteArray = new byte[20];
            byte recordFlag = buffer.get();
            buffer.get(globalByteArray);
            buffer.get(branchByteArray);
            buffer.get(resourceByteArray);
            TransactionXid globalXid = xidFactory.createGlobalXid(globalByteArray);
            TransactionXid branchXid = xidFactory.createBranchXid(globalXid, branchByteArray);
            String resourceId = StringUtils.trimToNull((String)new String(resourceByteArray));
            CleanupRecord record = new CleanupRecord();
            record.setStartIndex(current);
            record.setXid((Xid)branchXid);
            record.setRecordFlag(recordFlag);
            record.setEnabled((recordFlag & 1) == 1);
            record.setResource(resourceId);
            this.recordList.add(record);
            if (!record.isEnabled()) {
                removedList.add(record);
            } else {
                CleanupRecord removedRecord = (CleanupRecord)removedList.pollFirst();
                if (removedRecord == null) {
                    lastEnabledRecord = record;
                    this.registerRecord(record);
                } else {
                    removedRecord.setEnabled(record.isEnabled());
                    removedRecord.setRecordFlag(record.getRecordFlag());
                    removedRecord.setResource(record.getResource());
                    removedRecord.setXid(record.getXid());
                    this.forget(removedRecord);
                    this.delete(record);
                    removedList.add(record);
                    if (lastEnabledRecord != null && lastEnabledRecord.getStartIndex() < removedRecord.getStartIndex()) {
                        lastEnabledRecord = removedRecord;
                    }
                }
            }
            current = current + 63 + 1;
        }
        if (lastEnabledRecord != null && lastEnabledRecord.getStartIndex() + 63 + 1 > this.endIndex) {
            this.updateEndIndex(lastEnabledRecord.getStartIndex() + 63 + 1);
        }
        this.decreaseCapacityIfNecessary();
    }

    public void timingCompress() throws RuntimeException {
        LinkedList<CleanupRecord> removedList = new LinkedList<CleanupRecord>();
        CleanupRecord lastEnabledRecord = null;
        int current = CONSTANTS_START_INDEX;
        while (current < this.endIndex) {
            boolean forgetFlag;
            int index = (current - CONSTANTS_START_INDEX) / 64;
            CleanupRecord record = this.recordList.get(index);
            int memoRecordFlag = record.getRecordFlag();
            boolean memoEnabled = record.isEnabled();
            boolean bl = forgetFlag = (memoRecordFlag & 2) == 2;
            if (memoEnabled && forgetFlag) {
                this.delete(record);
                removedList.add(record);
            } else if (!memoEnabled) {
                removedList.add(record);
                this.unRegisterRecord(record);
            } else {
                CleanupRecord removedRecord = (CleanupRecord)removedList.pollFirst();
                if (removedRecord == null) {
                    lastEnabledRecord = record;
                } else {
                    removedRecord.setEnabled(record.isEnabled());
                    removedRecord.setRecordFlag(record.getRecordFlag());
                    removedRecord.setResource(record.getResource());
                    removedRecord.setXid(record.getXid());
                    this.forget(removedRecord);
                    this.delete(record);
                    removedList.add(record);
                    if (lastEnabledRecord != null && lastEnabledRecord.getStartIndex() < removedRecord.getStartIndex()) {
                        lastEnabledRecord = removedRecord;
                    }
                }
            }
            current = current + 63 + 1;
        }
        if (lastEnabledRecord != null && lastEnabledRecord.getStartIndex() + 63 + 1 > this.endIndex) {
            this.updateEndIndex(lastEnabledRecord.getStartIndex() + 63 + 1);
        }
        this.decreaseCapacityIfNecessary();
    }

    public void forget(CleanupRecord record) throws RuntimeException {
        Xid xid = record.getXid();
        String resourceId = record.getResource();
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        byte[] keyByteArray = resourceId.getBytes();
        byte[] resourceByteArray = new byte[23];
        System.arraycopy(keyByteArray, 0, resourceByteArray, 0, keyByteArray.length);
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.put((byte)record.getRecordFlag());
        buffer.put(globalTransactionId);
        buffer.put(branchQualifier);
        buffer.put(resourceByteArray);
        buffer.flip();
        try {
            this.channel.position(record.getStartIndex());
            buffer.rewind();
            this.channel.write(buffer);
            buffer.rewind();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        byte recordFlag = buffer.get();
        buffer.rewind();
        this.registerRecord(buffer, recordFlag, record.getStartIndex());
    }

    public void forget(Xid xid, String resourceId) throws RuntimeException {
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        byte[] keyByteArray = resourceId.getBytes();
        if (keyByteArray.length > 23) {
            throw new IllegalStateException("The resource name is too long!");
        }
        byte[] resourceByteArray = new byte[23];
        System.arraycopy(keyByteArray, 0, resourceByteArray, 0, keyByteArray.length);
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.put((byte)1);
        buffer.put(globalTransactionId);
        buffer.put(branchQualifier);
        buffer.put(resourceByteArray);
        buffer.flip();
        this.invokeForget(xid, resourceId, buffer);
    }

    private void invokeForget(Xid xid, String resource, ByteBuffer buffer) throws IllegalStateException {
        this.increaseCapacityIfNecessary();
        int recordIndex = this.endIndex;
        try {
            this.channel.position(recordIndex);
            buffer.rewind();
            this.channel.write(buffer);
            buffer.rewind();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        byte recordFlag = buffer.get();
        buffer.rewind();
        this.registerRecord(buffer, recordFlag, recordIndex);
        this.updateEndIndex(buffer.capacity() + this.endIndex);
    }

    private void registerRecord(ByteBuffer buffer, int recordFlag, int position) throws RuntimeException {
        XidFactory xidFactory = this.beanFactory.getTransactionXidFactory();
        byte[] resourceByteArray = new byte[23];
        byte[] globalByteArray = new byte[20];
        byte[] branchByteArray = new byte[20];
        buffer.rewind();
        buffer.get();
        buffer.get(globalByteArray);
        buffer.get(branchByteArray);
        buffer.get(resourceByteArray);
        TransactionXid globalXid = xidFactory.createGlobalXid(globalByteArray);
        TransactionXid branchXid = xidFactory.createBranchXid(globalXid, branchByteArray);
        String resourceId = StringUtils.trimToNull((String)new String(resourceByteArray));
        int index = (position - CONSTANTS_START_INDEX) / 64;
        if (index < this.recordList.size()) {
            CleanupRecord record = this.recordList.get(index);
            record.setRecordFlag(recordFlag);
            record.setEnabled((recordFlag & 1) == 1);
            record.setXid((Xid)branchXid);
            record.setResource(resourceId);
            this.registerRecord(record);
        } else if (index == this.recordList.size()) {
            CleanupRecord record = new CleanupRecord();
            record.setStartIndex(position);
            record.setRecordFlag(recordFlag);
            record.setEnabled((recordFlag & 1) == 1);
            record.setXid((Xid)branchXid);
            record.setResource(resourceId);
            this.recordList.add(record);
            this.registerRecord(record);
        } else {
            throw new IllegalStateException(String.format("Incorrect position: pos= %s, index= %s, size= %s.", position, index, this.recordList.size()));
        }
    }

    private void registerRecord(CleanupRecord record) throws RuntimeException {
        String resourceId = record.getResource();
        Set<CleanupRecord> records = this.recordMap.get(resourceId);
        if (records == null) {
            records = new HashSet<CleanupRecord>();
            this.recordMap.put(resourceId, records);
        }
        records.add(record);
    }

    private void unRegisterRecord(CleanupRecord record) throws RuntimeException {
        String resourceId = record.getResource();
        Set<CleanupRecord> records = this.recordMap.get(resourceId);
        if (records != null && !records.isEmpty()) {
            records.remove(record);
        }
    }

    private void updateEndIndex(int position) {
        this.endIndex = position;
        this.header.position(IDENTIFIER.length + 2 + 1 + 4);
        this.header.putInt(position);
        int recordUnit = 64;
        int textLength = this.endIndex - CONSTANTS_START_INDEX;
        int startIndex = textLength / recordUnit;
        for (int index = this.recordList.size() - 1; index >= startIndex; --index) {
            CleanupRecord record = this.recordList.remove(index);
            if (record == null) continue;
            this.unRegisterRecord(record);
        }
    }

    private void decreaseCapacityIfNecessary() {
        int length = this.sizeOfRaf - this.endIndex;
        int unit = 262144;
        int number = length / unit;
        if (number >= 2) {
            int decremental = unit * (number - 1);
            try {
                this.raf.setLength(this.sizeOfRaf - decremental);
                this.sizeOfRaf -= decremental;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void increaseCapacityIfNecessary() {
        if (this.endIndex == this.sizeOfRaf) {
            int incremental = 262144;
            try {
                this.raf.setLength(this.sizeOfRaf + incremental);
                this.sizeOfRaf += incremental;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void delete(CleanupRecord record) throws RuntimeException {
        record.setEnabled(false);
        record.setRecordFlag(0);
        try {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            int startIndex = record.getStartIndex();
            this.channel.position(startIndex);
            buffer.put((byte)0);
            buffer.flip();
            this.channel.write(buffer);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        this.unRegisterRecord(record);
    }

    public void destroy() {
        this.closeQuietly(this.channel);
        this.closeQuietly(this.raf);
    }

    public void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public Map<String, Set<CleanupRecord>> getRecordMap() {
        return this.recordMap;
    }

    @Override
    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    @Override
    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }
}

