/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.work;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.resource.spi.work.Work;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.jdbc.RecoveredResource;
import org.bytesoft.bytejta.supports.resource.LocalXAResourceDescriptor;
import org.bytesoft.bytetcc.supports.resource.LocalResourceCleaner;
import org.bytesoft.bytetcc.work.CleanupFile;
import org.bytesoft.bytetcc.work.CleanupRecord;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.transaction.supports.serialize.XAResourceDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupWork
implements Work,
LocalResourceCleaner,
CompensableEndpointAware,
CompensableBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(CleanupWork.class);
    static final byte[] IDENTIFIER = "org.bytesoft.bytetcc.resource.cleanup".getBytes();
    static final long SECOND_MILLIS = 1000L;
    static final int MAX_HANDLE_RECORDS = 200;
    static final int CONSTANTS_START_INDEX = IDENTIFIER.length + 2 + 4 + 4;
    static final int CONSTANTS_RES_ID_MAX_SIZE = 23;
    static final int CONSTANTS_RECORD_SIZE = 63;
    @Inject
    private CompensableBeanFactory beanFactory;
    private final Lock lock = new ReentrantLock();
    private final Lock startLock = new ReentrantLock();
    private final Condition startCond = this.startLock.newCondition();
    private boolean started;
    private File directory;
    private boolean released;
    private String endpoint;
    private final CleanupFile resourceOne = new CleanupFile("resource1.log");
    private final CleanupFile resourceTwo = new CleanupFile("resource2.log");
    private CleanupFile master = null;
    private CleanupFile slaver = null;

    public void initialize() {
        this.resourceOne.setDirectory(this.directory);
        this.resourceOne.setBeanFactory(this.beanFactory);
        this.resourceOne.setEndpoint(this.endpoint);
        this.resourceTwo.setDirectory(this.directory);
        this.resourceTwo.setBeanFactory(this.beanFactory);
        this.resourceTwo.setEndpoint(this.endpoint);
        byte masterFlagOne = this.resourceOne.initialize(true);
        byte masterFlagTwo = this.resourceTwo.initialize(false);
        if (masterFlagOne == 1 && masterFlagTwo == 0) {
            this.master = this.resourceOne;
            this.slaver = this.resourceTwo;
        } else if (masterFlagOne == 0 && masterFlagTwo == 1) {
            this.master = this.resourceTwo;
            this.slaver = this.resourceOne;
        } else {
            if (masterFlagOne == 0 && masterFlagTwo == 0) {
                throw new IllegalStateException("Illegal state!");
            }
            if (masterFlagOne == 2 && masterFlagTwo == 1) {
                this.resourceTwo.markSlaver();
                this.resourceOne.markMaster();
                this.master = this.resourceOne;
                this.slaver = this.resourceTwo;
            } else if (masterFlagOne == 2 && masterFlagTwo == 0) {
                this.resourceOne.markMaster();
                this.master = this.resourceOne;
                this.slaver = this.resourceTwo;
            } else if (masterFlagOne == 1 && masterFlagTwo == 2) {
                this.resourceOne.markSlaver();
                this.resourceTwo.markMaster();
                this.master = this.resourceTwo;
                this.slaver = this.resourceOne;
            } else if (masterFlagOne == 0 && masterFlagTwo == 2) {
                this.resourceTwo.markMaster();
                this.master = this.resourceTwo;
                this.slaver = this.resourceOne;
            } else {
                throw new IllegalStateException("Illegal state!");
            }
        }
    }

    public void startupRecover() {
        this.master.startupRecover();
        this.slaver.startupRecover();
    }

    public void destroy() {
        this.resourceOne.destroy();
        this.resourceTwo.destroy();
    }

    public void run() {
        this.startupRecover();
        this.markStartupDone();
        long swapMillis = System.currentTimeMillis() + 30000L;
        while (!this.released) {
            if (System.currentTimeMillis() < swapMillis) {
                this.waitingFor(100L);
                continue;
            }
            this.switchMasterAndSlaver();
            swapMillis = System.currentTimeMillis() + 30000L;
            this.cleanupSlaver();
            this.compressSlaver();
        }
        this.destroy();
    }

    protected void waitingFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            logger.error(ex.getMessage());
        }
    }

    private void compressSlaver() {
        this.slaver.timingCompress();
    }

    private void cleanupSlaver() {
        Map<String, Set<CleanupRecord>> recordMap = this.slaver.getRecordMap();
        Set<Map.Entry<String, Set<CleanupRecord>>> entrySet = recordMap.entrySet();
        for (Map.Entry<String, Set<CleanupRecord>> entry : entrySet) {
            String resourceId = entry.getKey();
            Set<CleanupRecord> records = entry.getValue();
            this.cleanupByResource(resourceId, records);
        }
    }

    private void cleanupByResource(String resourceId, Set<CleanupRecord> records) {
        int remain = records.size();
        Iterator<CleanupRecord> recordItr = records.iterator();
        while (recordItr.hasNext()) {
            CleanupRecord record;
            ArrayList<CleanupRecord> recordList = new ArrayList<CleanupRecord>();
            ArrayList<Xid> xidList = new ArrayList<Xid>();
            int defaultBatchSize = 2000;
            int maxBatchSize = defaultBatchSize * 5 / 4;
            int batchSize = remain > defaultBatchSize && remain < maxBatchSize ? remain : defaultBatchSize;
            int i = 0;
            while (i < batchSize && recordItr.hasNext()) {
                record = recordItr.next();
                recordList.add(record);
                xidList.add(record.getXid());
                ++i;
                --remain;
            }
            try {
                this.cleanup(resourceId, xidList);
            }
            catch (RuntimeException rex) {
                logger.error("forget-transaction: error occurred while forgetting branch: resource= {}, xids= {}", new Object[]{resourceId, xidList, rex});
                return;
            }
            for (i = 0; i < recordList.size(); ++i) {
                record = (CleanupRecord)recordList.get(i);
                int recordFlag = record.getRecordFlag();
                record.setRecordFlag(recordFlag | 2);
            }
        }
    }

    public void switchMasterAndSlaver() {
        try {
            this.lock.lock();
            this.slaver.markPrepare();
            this.master.markSlaver();
            this.slaver.markMaster();
            CleanupFile cleanupFile = this.master;
            this.master = this.slaver;
            this.slaver = cleanupFile;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void cleanup(String resourceId, List<Xid> xidList) throws RuntimeException {
        XAResourceDeserializer resourceDeserializer = this.beanFactory.getResourceDeserializer();
        if (StringUtils.isBlank((CharSequence)resourceId)) {
            throw new IllegalStateException();
        }
        Xid[] xidArray = new Xid[xidList.size()];
        xidList.toArray(xidArray);
        LocalXAResourceDescriptor descriptor = (LocalXAResourceDescriptor)resourceDeserializer.deserialize(resourceId);
        RecoveredResource resource = (RecoveredResource)descriptor.getDelegate();
        try {
            resource.forget(xidArray);
        }
        catch (XAException xaex) {
            logger.error("Error occurred while forgetting resource: {}.", (Object)resourceId, (Object)xaex);
            switch (xaex.errorCode) {
                case -4: {
                    break;
                }
                case -7: 
                case -3: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void forget(Xid xid, String resourceId) throws RuntimeException {
        this.waitForStartup();
        try {
            this.lock.lock();
            this.master.forget(xid, resourceId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void markStartupDone() {
        try {
            this.startLock.lock();
            this.started = true;
            this.startCond.signalAll();
        }
        finally {
            this.startLock.unlock();
        }
    }

    public void waitForStartup() {
        if (!this.started) {
            try {
                this.startLock.lock();
                while (!this.started) {
                    try {
                        this.startCond.await(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ex) {
                        logger.debug(ex.getMessage());
                    }
                }
            }
            finally {
                this.startLock.unlock();
            }
        }
    }

    public void release() {
        this.released = true;
    }

    @Override
    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    @Override
    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }
}

