/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.work;

import javax.inject.Inject;
import javax.resource.spi.work.Work;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.transaction.TransactionRecovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableWork
implements Work,
CompensableBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(CompensableWork.class);
    static final long SECOND_MILLIS = 1000L;
    private long stopTimeMillis = -1L;
    private long delayOfStoping = 15000L;
    private long recoveryInterval = 60000L;
    private boolean initialized = false;
    @Inject
    private CompensableBeanFactory beanFactory;

    private void initializeIfNecessary() {
        TransactionRecovery compensableRecovery = this.beanFactory.getCompensableRecovery();
        if (!this.initialized) {
            try {
                compensableRecovery.startRecovery();
                this.initialized = true;
                compensableRecovery.timingRecover();
            }
            catch (RuntimeException rex) {
                logger.error("Error occurred while initializing the compensable work.", (Throwable)rex);
            }
        }
    }

    public void run() {
        TransactionRecovery compensableRecovery = this.beanFactory.getCompensableRecovery();
        this.initializeIfNecessary();
        long nextRecoveryTime = 0L;
        while (this.currentActive()) {
            this.initializeIfNecessary();
            long current = System.currentTimeMillis();
            if (current >= nextRecoveryTime) {
                nextRecoveryTime = current + this.recoveryInterval;
                try {
                    compensableRecovery.timingRecover();
                }
                catch (RuntimeException rex) {
                    logger.error(rex.getMessage(), (Throwable)rex);
                }
            }
            this.waitForMillis(100L);
        }
    }

    private void waitForMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception ignore) {
            logger.debug(ignore.getMessage(), (Throwable)ignore);
        }
    }

    public void release() {
        this.stopTimeMillis = System.currentTimeMillis() + this.delayOfStoping;
    }

    protected boolean currentActive() {
        return this.stopTimeMillis <= 0L || System.currentTimeMillis() < this.stopTimeMillis;
    }

    public long getDelayOfStoping() {
        return this.delayOfStoping;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setDelayOfStoping(long delayOfStoping) {
        this.delayOfStoping = delayOfStoping;
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

