/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.compensable.archive;

import javax.transaction.xa.Xid;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableInvocation;

public class CompensableArchive {
    private Xid identifier;
    private boolean coordinator;
    private CompensableInvocation compensable;
    private String transactionResourceKey;
    private Xid transactionXid;
    private boolean tried;
    private String compensableResourceKey;
    private Xid compensableXid;
    private boolean confirmed;
    private boolean cancelled;

    public String toString() {
        String key = this.identifier == null || this.identifier.getGlobalTransactionId() == null ? null : ByteUtils.byteArrayToString((byte[])this.identifier.getGlobalTransactionId());
        return String.format("[compensable-archive| identifier= %s, transactionKey= %s, transactionXid= %s, compensableKey= %s, compensableXid= %s, confirmed= %s, cancelled= %s]", key, this.transactionResourceKey, this.transactionXid, this.compensableResourceKey, this.compensableXid, this.confirmed, this.cancelled);
    }

    public int hashCode() {
        int hash = 23;
        hash += 29 * (this.transactionXid == null ? 0 : this.transactionXid.hashCode());
        return hash += 31 * (this.compensableXid == null ? 0 : this.compensableXid.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CompensableArchive that = (CompensableArchive)obj;
        boolean transactionXidEquals = CommonUtils.equals((Object)this.transactionXid, (Object)that.transactionXid);
        boolean compensableXidEquals = CommonUtils.equals((Object)this.compensableXid, (Object)that.compensableXid);
        return transactionXidEquals && compensableXidEquals;
    }

    public Xid getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Xid identifier) {
        this.identifier = identifier;
    }

    public Xid getTransactionXid() {
        return this.transactionXid;
    }

    public void setTransactionXid(Xid transactionXid) {
        this.transactionXid = transactionXid;
    }

    public Xid getCompensableXid() {
        return this.compensableXid;
    }

    public void setCompensableXid(Xid compensableXid) {
        this.compensableXid = compensableXid;
    }

    public CompensableInvocation getCompensable() {
        return this.compensable;
    }

    public void setCompensable(CompensableInvocation compensable) {
        this.compensable = compensable;
    }

    public boolean isTried() {
        return this.tried;
    }

    public void setTried(boolean tried) {
        this.tried = tried;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(boolean coordinator) {
        this.coordinator = coordinator;
    }

    public String getTransactionResourceKey() {
        return this.transactionResourceKey;
    }

    public void setTransactionResourceKey(String transactionResourceKey) {
        this.transactionResourceKey = transactionResourceKey;
    }

    public String getCompensableResourceKey() {
        return this.compensableResourceKey;
    }

    public void setCompensableResourceKey(String compensableResourceKey) {
        this.compensableResourceKey = compensableResourceKey;
    }
}

