/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.io.Serializable;
import java.util.Date;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class JobDeclaration<S, T extends JobEntity>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String jobDefinitionId;
    protected String jobHandlerType;
    protected JobHandlerConfiguration jobHandlerConfiguration;
    protected String jobConfiguration;
    protected boolean exclusive = true;
    protected ActivityImpl activity;
    protected ParameterValueProvider jobPriorityProvider;

    public JobDeclaration(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public T createJobInstance(S context) {
        JobDefinitionEntity jobDefinition;
        T job = this.newJobInstance(context);
        String jobDefinitionId = this.resolveJobDefinitionId(context);
        ((JobEntity)job).setJobDefinitionId(jobDefinitionId);
        if (jobDefinitionId != null && (jobDefinition = Context.getCommandContext().getJobDefinitionManager().findById(jobDefinitionId)) != null) {
            ((JobEntity)job).setSuspensionState(jobDefinition.getSuspensionState());
            ((JobEntity)job).setProcessDefinitionKey(jobDefinition.getProcessDefinitionKey());
            ((JobEntity)job).setProcessDefinitionId(jobDefinition.getProcessDefinitionId());
            ((JobEntity)job).setTenantId(jobDefinition.getTenantId());
        }
        ((JobEntity)job).setJobHandlerConfiguration(this.resolveJobHandlerConfiguration(context));
        ((JobEntity)job).setJobHandlerType(this.resolveJobHandlerType(context));
        ((JobEntity)job).setExclusive(this.resolveExclusive(context));
        ((JobEntity)job).setRetries(this.resolveRetries(context));
        ((JobEntity)job).setDuedate(this.resolveDueDate(context));
        ExecutionEntity contextExecution = this.resolveExecution(context);
        if (Context.getProcessEngineConfiguration().isProducePrioritizedJobs()) {
            long priority = Context.getProcessEngineConfiguration().getJobPriorityProvider().determinePriority(contextExecution, this, jobDefinitionId);
            ((JobEntity)job).setPriority(priority);
        }
        if (contextExecution != null) {
            ((JobEntity)job).setTenantId(contextExecution.getTenantId());
        }
        this.postInitialize(context, job);
        return job;
    }

    public T reconfigure(S context, T job) {
        return job;
    }

    protected void postInitialize(S context, T job) {
    }

    protected abstract ExecutionEntity resolveExecution(S var1);

    protected abstract T newJobInstance(S var1);

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    protected String resolveJobDefinitionId(S context) {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    protected JobHandler resolveJobHandler() {
        JobHandler jobHandler = Context.getProcessEngineConfiguration().getJobHandlers().get(this.jobHandlerType);
        EnsureUtil.ensureNotNull("Cannot find job handler '" + this.jobHandlerType + "' from job '" + this + "'", "jobHandler", (Object)jobHandler);
        return jobHandler;
    }

    protected String resolveJobHandlerType(S context) {
        return this.jobHandlerType;
    }

    protected abstract JobHandlerConfiguration resolveJobHandlerConfiguration(S var1);

    protected boolean resolveExclusive(S context) {
        return this.exclusive;
    }

    protected int resolveRetries(S context) {
        return Context.getProcessEngineConfiguration().getDefaultNumberOfRetries();
    }

    public Date resolveDueDate(S context) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration != null && processEngineConfiguration.isJobExecutorAcquireByDueDate()) {
            return ClockUtil.getCurrentTime();
        }
        return null;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public String getActivityId() {
        if (this.activity != null) {
            return this.activity.getId();
        }
        return null;
    }

    public ActivityImpl getActivity() {
        return this.activity;
    }

    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        if (this.activity != null) {
            return this.activity.getProcessDefinition();
        }
        return null;
    }

    public String getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setJobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    public ParameterValueProvider getJobPriorityProvider() {
        return this.jobPriorityProvider;
    }

    public void setJobPriorityProvider(ParameterValueProvider jobPriorityProvider) {
        this.jobPriorityProvider = jobPriorityProvider;
    }
}

