/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.task.impl;

import java.util.Map;
import org.camunda.bpm.client.impl.EngineClient;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskService;

public class ExternalTaskServiceImpl
implements ExternalTaskService {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected EngineClient engineClient;

    public ExternalTaskServiceImpl(EngineClient engineClient) {
        this.engineClient = engineClient;
    }

    @Override
    public void lock(ExternalTask externalTask, long lockDuration) {
        this.lock(externalTask.getId(), lockDuration);
    }

    @Override
    public void lock(String externalTaskId, long lockDuration) {
        try {
            this.engineClient.lock(externalTaskId, lockDuration);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("locking task", e);
        }
    }

    @Override
    public void unlock(ExternalTask externalTask) {
        try {
            this.engineClient.unlock(externalTask.getId());
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("unlocking the external task", e);
        }
    }

    @Override
    public void complete(ExternalTask externalTask) {
        this.complete(externalTask, null, null);
    }

    @Override
    public void complete(ExternalTask externalTask, Map<String, Object> variables) {
        this.complete(externalTask, variables, null);
    }

    @Override
    public void complete(ExternalTask externalTask, Map<String, Object> variables, Map<String, Object> localVariables) {
        this.complete(externalTask.getId(), variables, localVariables);
    }

    @Override
    public void complete(String externalTaskId, Map<String, Object> variables, Map<String, Object> localVariables) {
        try {
            this.engineClient.complete(externalTaskId, variables, localVariables);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("completing the external task", e);
        }
    }

    @Override
    public void handleFailure(ExternalTask externalTask, String errorMessage, String errorDetails, int retries, long retryTimeout) {
        this.handleFailure(externalTask.getId(), errorMessage, errorDetails, retries, retryTimeout);
    }

    @Override
    public void handleFailure(String externalTaskId, String errorMessage, String errorDetails, int retries, long retryTimeout) {
        this.handleFailure(externalTaskId, errorMessage, errorDetails, retries, retryTimeout, null, null);
    }

    @Override
    public void handleFailure(String externalTaskId, String errorMessage, String errorDetails, int retries, long retryTimeout, Map<String, Object> variables, Map<String, Object> locaclVariables) {
        try {
            this.engineClient.failure(externalTaskId, errorMessage, errorDetails, retries, retryTimeout, variables, locaclVariables);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("notifying a failure", e);
        }
    }

    @Override
    public void handleBpmnError(ExternalTask externalTask, String errorCode) {
        this.handleBpmnError(externalTask, errorCode, null, null);
    }

    @Override
    public void handleBpmnError(ExternalTask externalTask, String errorCode, String errorMessage) {
        this.handleBpmnError(externalTask, errorCode, errorMessage, null);
    }

    @Override
    public void handleBpmnError(ExternalTask externalTask, String errorCode, String errorMessage, Map<String, Object> variables) {
        this.handleBpmnError(externalTask.getId(), errorCode, errorMessage, variables);
    }

    @Override
    public void handleBpmnError(String externalTaskId, String errorCode, String errorMessage, Map<String, Object> variables) {
        try {
            this.engineClient.bpmnError(externalTaskId, errorCode, errorMessage, variables);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("notifying a BPMN error", e);
        }
    }

    @Override
    public void extendLock(ExternalTask externalTask, long newDuration) {
        this.extendLock(externalTask.getId(), newDuration);
    }

    @Override
    public void extendLock(String externalTaskId, long newDuration) {
        try {
            this.engineClient.extendLock(externalTaskId, newDuration);
        }
        catch (EngineClientException e) {
            throw LOG.externalTaskServiceException("extending lock", e);
        }
    }
}

