/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom.format;

import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.camunda.spin.spi.DataFormatWriter;
import org.w3c.dom.Node;

public class DomXmlDataFormatWriter
implements DataFormatWriter {
    protected static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected DomXmlDataFormat domXmlDataFormat;

    public DomXmlDataFormatWriter(DomXmlDataFormat domXmlDataFormat) {
        this.domXmlDataFormat = domXmlDataFormat;
    }

    public void writeToWriter(Writer writer, Object input) {
        this.writeResult(new StreamResult(writer), input);
    }

    protected void writeResult(StreamResult streamResult, Object input) {
        Node node = (Node)input;
        DOMSource domSource = new DOMSource(node);
        try {
            this.getTransformer().transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            throw LOG.unableToTransformElement(node, e);
        }
    }

    protected Transformer getTransformer() {
        TransformerFactory transformerFactory = this.domXmlDataFormat.getTransformerFactory();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw LOG.unableToCreateTransformer(e);
        }
    }
}

