/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal.path;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import spinjar.com.jayway.jsonpath.Predicate;
import spinjar.com.jayway.jsonpath.internal.function.Parameter;
import spinjar.com.jayway.jsonpath.internal.path.ArrayIndexOperation;
import spinjar.com.jayway.jsonpath.internal.path.ArrayPathToken;
import spinjar.com.jayway.jsonpath.internal.path.ArraySliceOperation;
import spinjar.com.jayway.jsonpath.internal.path.FunctionPathToken;
import spinjar.com.jayway.jsonpath.internal.path.PathToken;
import spinjar.com.jayway.jsonpath.internal.path.PredicatePathToken;
import spinjar.com.jayway.jsonpath.internal.path.PropertyPathToken;
import spinjar.com.jayway.jsonpath.internal.path.RootPathToken;
import spinjar.com.jayway.jsonpath.internal.path.ScanPathToken;
import spinjar.com.jayway.jsonpath.internal.path.WildcardPathToken;

public class PathTokenFactory {
    public static RootPathToken createRootPathToken(char token) {
        return new RootPathToken(token);
    }

    public static PathToken createSinglePropertyPathToken(String property, char stringDelimiter) {
        return new PropertyPathToken(Collections.singletonList(property), stringDelimiter);
    }

    public static PathToken createPropertyPathToken(List<String> properties, char stringDelimiter) {
        return new PropertyPathToken(properties, stringDelimiter);
    }

    public static PathToken createSliceArrayPathToken(ArraySliceOperation arraySliceOperation) {
        return new ArrayPathToken(arraySliceOperation);
    }

    public static PathToken createIndexArrayPathToken(ArrayIndexOperation arrayIndexOperation) {
        return new ArrayPathToken(arrayIndexOperation);
    }

    public static PathToken createWildCardPathToken() {
        return new WildcardPathToken();
    }

    public static PathToken crateScanToken() {
        return new ScanPathToken();
    }

    public static PathToken createPredicatePathToken(Collection<Predicate> predicates) {
        return new PredicatePathToken(predicates);
    }

    public static PathToken createPredicatePathToken(Predicate predicate) {
        return new PredicatePathToken(predicate);
    }

    public static PathToken createFunctionPathToken(String function, List<Parameter> parameters) {
        return new FunctionPathToken(function, parameters);
    }
}

