/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.loader;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.castor.core.util.AbstractProperties;
import org.castor.xml.XMLProperties;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionHandlers {
    private static Info[] _info;
    private static Class _collectionClass;
    private static boolean _loadedCollectionClass;

    public static Class<?> getCollectionType(String name) throws MappingException {
        for (Info info : _info) {
            if (!info.getShortName().equalsIgnoreCase(name) && !info.getJavaClass().getName().equals(name)) continue;
            return info.getJavaClass();
        }
        if (!_loadedCollectionClass) {
            _loadedCollectionClass = true;
            try {
                _collectionClass = Class.forName("java.util.Collection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return _collectionClass;
    }

    public static boolean hasHandler(Class<?> javaClass) {
        if (javaClass.isArray() && javaClass.getComponentType() != Byte.TYPE) {
            javaClass = Object[].class;
        }
        for (Info info : _info) {
            if (!info.getJavaClass().isAssignableFrom(javaClass)) continue;
            return true;
        }
        return false;
    }

    public static String getCollectionName(Class<?> javaClass) {
        int i;
        if (javaClass.isArray() && javaClass.getComponentType() != Byte.TYPE) {
            javaClass = Object[].class;
        }
        for (i = 0; i < _info.length; ++i) {
            if (!_info[i].getJavaClass().equals(javaClass)) continue;
            return _info[i].getShortName();
        }
        for (i = 0; i < _info.length; ++i) {
            if (!_info[i].getJavaClass().isAssignableFrom(javaClass)) continue;
            return _info[i].getShortName();
        }
        return null;
    }

    public static CollectionHandler getHandler(Class<?> javaClass) throws MappingException {
        int i;
        if (javaClass.isArray() && javaClass.getComponentType() != Byte.TYPE) {
            javaClass = Object[].class;
        }
        for (i = 0; i < _info.length; ++i) {
            if (!_info[i].getJavaClass().equals(javaClass)) continue;
            return _info[i].handler;
        }
        for (i = 0; i < _info.length; ++i) {
            if (!_info[i].getJavaClass().isAssignableFrom(javaClass)) continue;
            return _info[i].handler;
        }
        throw new MappingException("mapping.noCollectionHandler", javaClass.getName());
    }

    public static boolean isGetSetCollection(Class<?> javaClass) throws MappingException {
        for (int i = 0; i < _info.length; ++i) {
            if (!_info[i].getJavaClass().equals(javaClass)) continue;
            return CollectionHandlers._info[i].getSetCollection;
        }
        throw new MappingException("mapping.noCollectionHandler", javaClass.getName());
    }

    static {
        _collectionClass = null;
        _loadedCollectionClass = false;
        Vector<Info> allInfo = new Vector<Info>();
        AbstractProperties properties = XMLProperties.newInstance();
        StringTokenizer tokenizer = new StringTokenizer(properties.getString("org.exolab.castor.mapping.collections", ""), ", ");
        while (tokenizer.hasMoreTokens()) {
            try {
                Class<?> infoClass = CollectionHandlers.class.getClassLoader() != null ? CollectionHandlers.class.getClassLoader().loadClass(tokenizer.nextToken()) : Class.forName(tokenizer.nextToken());
                Method method = infoClass.getMethod("getCollectionHandlersInfo", null);
                Info[] info = (Info[])method.invoke(null, (Object[])null);
                for (int i = 0; i < info.length; ++i) {
                    allInfo.addElement(info[i]);
                }
            }
            catch (Exception exception) {
            }
        }
        _info = new Info[allInfo.size()];
        allInfo.copyInto(_info);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EmptyEnumerator<T>
    implements Enumeration<T>,
    Serializable {
        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Info {
        private final String shortName;
        private final Class<?> javaClass;
        private final CollectionHandler handler;
        final boolean getSetCollection;

        Info(String shortName, Class<?> javaClass, boolean getSetCollection, CollectionHandler handler) {
            this.shortName = shortName;
            this.javaClass = javaClass;
            this.handler = handler;
            this.getSetCollection = getSetCollection;
        }

        String getShortName() {
            return this.shortName;
        }

        Class<?> getJavaClass() {
            return this.javaClass;
        }

        CollectionHandler getHandler() {
            return this.handler;
        }
    }
}

