/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.recognizer;

import org.sonar.squid.recognizer.Detector;

public class EndWithDetector
extends Detector {
    private char[] endOfLines;

    public EndWithDetector(double probability, char ... endOfLines) {
        super(probability);
        this.endOfLines = endOfLines;
    }

    @Override
    public int scan(String line) {
        for (int index = line.length() - 1; index >= 0; --index) {
            char character = line.charAt(index);
            for (char endOfLine : this.endOfLines) {
                if (character != endOfLine) continue;
                return 1;
            }
            if (Character.isWhitespace(character) || character == '*' || character == '/') continue;
            return 0;
        }
        return 0;
    }
}

