/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.ir.BinaryNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.Label;

public class BooleanNode
extends BinaryNode {
    private Operation operation;

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitBoolean(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getLeftNode().visit(irTreeVisitor, scope);
        this.getRightNode().visit(irTreeVisitor, scope);
    }

    public BooleanNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.operation == Operation.AND) {
            Label fals = new Label();
            Label end = new Label();
            this.getLeftNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, fals);
            this.getRightNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else if (this.operation == Operation.OR) {
            Label tru = new Label();
            Label fals = new Label();
            Label end = new Label();
            this.getLeftNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(154, tru);
            this.getRightNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.mark(tru);
            methodWriter.push(true);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(false);
            methodWriter.mark(end);
        } else {
            throw new IllegalStateException("unexpected boolean operation [" + (Object)((Object)this.operation) + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
        }
    }
}

