/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concurrent.components;

import java.util.concurrent.atomic.AtomicLong;

public class PriorityRunnable
implements Runnable,
Comparable<PriorityRunnable> {
    private final int priority;
    private final Runnable task;
    static final AtomicLong seq = new AtomicLong(0L);
    private final long seqNum = seq.getAndIncrement();

    public PriorityRunnable(int priority, Runnable task) {
        this.priority = Math.min(10, Math.min(priority, 1));
        this.task = task;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public void run() {
        if (this.task != null) {
            Thread.currentThread().setPriority(this.getPriority());
            this.task.run();
        }
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    @Override
    public int compareTo(PriorityRunnable o) {
        if (o == null) {
            return 1;
        }
        return o.getPriority() == this.getPriority() ? (this.getSeqNum() < o.getSeqNum() ? -1 : 1) : (this.getPriority() > o.getPriority() ? -1 : 1);
    }
}

