/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import org.coodex.pojomocker.AbstractUnmockFieldMocker;
import org.coodex.pojomocker.MockContext;
import org.coodex.pojomocker.POJOMockInfo;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CI_PrivimitiveTypeMocker
extends AbstractUnmockFieldMocker {
    private static Logger log = LoggerFactory.getLogger(CI_PrivimitiveTypeMocker.class);
    private static final Class<?>[] PRIVIMITIVE_TYPES = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};

    @Override
    protected boolean access(Class<?> clz) {
        return clz.isPrimitive() || Common.inArray(clz, PRIVIMITIVE_TYPES);
    }

    @Override
    protected <T> T newInstance(Class<T> clz, MockContext context) {
        if (this.isByte(clz)) {
            return (T)Byte.valueOf((byte)this.mockInt(context));
        }
        if (this.isChar(clz)) {
            return (T)Character.valueOf((char)this.mockInt(context));
        }
        if (this.isBoolean(clz)) {
            return (T)Boolean.valueOf(this.mockBool(context));
        }
        if (this.isShort(clz)) {
            return (T)Short.valueOf((short)this.mockInt(context));
        }
        if (this.isInt(clz)) {
            return (T)Integer.valueOf(this.mockInt(context));
        }
        if (this.isLong(clz)) {
            return (T)Long.valueOf(this.mockInt(context));
        }
        if (this.isFloat(clz)) {
            return (T)Float.valueOf((float)this.mockDouble(context));
        }
        if (this.isDouble(clz)) {
            return (T)Double.valueOf(this.mockDouble(context));
        }
        return null;
    }

    private int mockInt(MockContext context) {
        POJOMockInfo pmi = context.getMockInfo();
        Object mockObj = context.getInstance();
        try {
            if (!"".equals(pmi.getSizeOf()) && mockObj != null) {
                Field fieldTarget = mockObj.getClass().getDeclaredField(pmi.getSizeOf());
                fieldTarget.setAccessible(true);
                Class<?> clz = fieldTarget.getClass();
                Object collectionObj = fieldTarget.get(mockObj);
                if (collectionObj == null) {
                    return 0;
                }
                if (clz.isArray()) {
                    return Array.getLength(collectionObj);
                }
                if (Collection.class.isAssignableFrom(clz)) {
                    return ((Collection)collectionObj).size();
                }
                if (CharSequence.class.isAssignableFrom(clz)) {
                    return ((CharSequence)collectionObj).length();
                }
            }
        }
        catch (Throwable e) {
            log.debug("mock failed. {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return Common.random(pmi.getMin(), pmi.getMax());
    }

    private boolean mockBool(MockContext context) {
        return Math.random() < 0.5;
    }

    private double mockDouble(MockContext context) {
        POJOMockInfo pmi = context.getMockInfo();
        return Math.random() + (double)Common.random(pmi.getMin(), pmi.getMax() - 1);
    }

    private boolean isInt(Class<?> clz) {
        return clz == Integer.TYPE || clz == Integer.class;
    }

    private boolean isLong(Class<?> clz) {
        return clz == Long.TYPE || clz == Long.class;
    }

    private boolean isChar(Class<?> clz) {
        return clz == Character.TYPE || clz == Character.class;
    }

    private boolean isByte(Class<?> clz) {
        return clz == Byte.TYPE || clz == Byte.class;
    }

    private boolean isShort(Class<?> clz) {
        return clz == Short.TYPE || clz == Short.class;
    }

    private boolean isBoolean(Class<?> clz) {
        return clz == Boolean.TYPE || clz == Boolean.class;
    }

    private boolean isFloat(Class<?> clz) {
        return clz == Float.TYPE || clz == Float.class;
    }

    private boolean isDouble(Class<?> clz) {
        return clz == Double.TYPE || clz == Double.class;
    }
}

