/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.pojomocker;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.coodex.pojomocker.POJOMockInfo;
import org.coodex.pojomocker.POJOMocker;
import org.coodex.pojomocker.POJOMockerFactory;
import org.coodex.pojomocker.TypeVariantReplaceKey;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public class MockContext {
    private final Map<Class<?>, Integer> created = new HashMap();
    private MockContext parent = null;
    private POJOMockInfo mockInfo = null;
    private Object instance = null;
    private Map<TypeVariantReplaceKey, Type> replaceMap = new HashMap<TypeVariantReplaceKey, Type>();
    private List<Type> contextClasses = new ArrayList<Type>();
    private int arrayLevel = 0;

    public Map<Class<?>, Integer> getCreated() {
        return this.created;
    }

    public void addCreatedCount(Class<?> clz) {
        Integer i = this.created.get(clz);
        if (i == null) {
            i = 1;
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        this.created.put(clz, i);
    }

    MockContext(MockContext parent) {
        if (parent != null) {
            Common.copyMap(parent.created, this.created);
            this.mockInfo = parent.mockInfo;
            this.arrayLevel = parent.arrayLevel;
            this.instance = parent.instance;
            this.replaceMap.putAll(parent.replaceMap);
            this.contextClasses.addAll(parent.contextClasses);
            this.parent = parent;
        }
    }

    MockContext addContextType(Type contextClass) {
        this.contextClasses.add(contextClass);
        return this;
    }

    void addReplace(Type declared, int index, Type changeTo) {
        this.replaceMap.put(new TypeVariantReplaceKey(index, declared), changeTo);
    }

    public Object getInstance() {
        return this.instance;
    }

    private Type getReplacedType(TypeVariable<Class<?>> type) {
        TypeVariable<Class<?>>[] types = type.getGenericDeclaration().getTypeParameters();
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            if (!type.equals(types[i])) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            return this.replaceMap.get(new TypeVariantReplaceKey(index, type.getGenericDeclaration()));
        }
        return null;
    }

    public Type findTypeVariableActurlType(TypeVariable<Class<?>> type) {
        Type t = this.getReplacedType(type);
        if (t != null) {
            return t;
        }
        for (int i = this.contextClasses.size() - 1; i >= 0; --i) {
            t = TypeHelper.findActualClassFromInstanceClass(type, this.contextClasses.get(i));
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public MockContext getParent() {
        return this.parent;
    }

    public POJOMockInfo getMockInfo() {
        return this.mockInfo;
    }

    public void setMockInfo(POJOMockInfo mockInfo) {
        this.mockInfo = mockInfo;
    }

    public POJOMockerFactory getFactory() {
        return POJOMocker.getFactory(this.mockInfo.getFactoryClass());
    }

    public void arrayLevelAdd() {
        ++this.arrayLevel;
    }

    public void arrayLevelReduce() {
        --this.arrayLevel;
    }

    public int getArrayLevel() {
        return this.arrayLevel;
    }
}

