/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coodex.util.DigestHelper;
import org.coodex.util.UUIDHelper;

public class Common {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static <T> Set<T> arrayToSet(T[] array) {
        HashSet<T> set = new HashSet<T>();
        for (T t : array) {
            set.add(t);
        }
        return set;
    }

    public static String getUUIDStr() {
        return UUIDHelper.getUUIDString();
    }

    public static String sha1(String content) {
        byte[] buf = content == null ? new byte[]{} : content.getBytes();
        return DigestHelper.sha1(buf);
    }

    public static <T> boolean inArray(T el, T[] array) {
        return Common.findInArray(el, array) >= 0;
    }

    public static <T> int findInArray(T el, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (el != t && (t == null || !t.equals(el))) continue;
            return i;
        }
        return -1;
    }

    public static String nullToStr(String str) {
        return str == null ? "" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T deepCopy(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject(object);
        }
        finally {
            oos.close();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        finally {
            ois.close();
        }
    }

    public static int random(int max) {
        return Common.random(0, max);
    }

    public static int random(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static <K extends Serializable, V extends Serializable> void copyMap(Map<K, V> org, Map<K, V> target) {
        for (Serializable key : org.keySet()) {
            try {
                target.put(Common.deepCopy(key), Common.deepCopy((Serializable)org.get(key)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        Common.copyStream(is, os, 4096, false, Integer.MAX_VALUE);
    }

    public static void copyStream(InputStream is, OutputStream os, int blockSize, boolean flushPerBlock, int bps) throws IOException {
        byte[] buf = new byte[blockSize];
        int cached = -1;
        long start = Calendar.getInstance().getTimeInMillis();
        long wrote = 0L;
        while ((cached = is.read(buf)) > 0) {
            if (wrote >= (long)bps) {
                long n = wrote / (long)bps;
                wrote %= (long)bps;
                long interval = Calendar.getInstance().getTimeInMillis() - start;
                try {
                    if (interval < 1000L * n) {
                        Thread.sleep(interval);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            start = Calendar.getInstance().getTimeInMillis();
            os.write(buf, 0, cached);
            if (!flushPerBlock) continue;
            os.flush();
            wrote += (long)cached;
        }
        if (!flushPerBlock) {
            os.flush();
        }
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        for (int n = 0; n < b.length; ++n) {
            String sTmp = Integer.toHexString(b[n] & 0xFF);
            hs = sTmp.length() == 1 ? hs + "0" + sTmp : hs + sTmp;
        }
        return hs.toUpperCase();
    }

    public static <T> Set<T> intersection(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(set1);
        result.retainAll(set2);
        return result;
    }

    public static <T> Set<T> difference(Set<T> org, Set<T> todiv) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(org);
        result.removeAll(todiv);
        return result;
    }

    public static <T> Set<T> join(Set<T> ary1, Set<T> ary2) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(ary1);
        result.addAll(ary2);
        return result;
    }

    public static String native2AscII(String str) {
        if (str == null) {
            return null;
        }
        char[] charPoints = str.toCharArray();
        StringBuffer strBuf = new StringBuffer();
        for (char ch : charPoints) {
            if (ch < '\u0100') {
                strBuf.append(ch);
                continue;
            }
            strBuf.append("\\u").append(Integer.toHexString(ch));
        }
        return strBuf.toString();
    }

    @Deprecated
    public static File getFile(String fileName) throws IOException {
        return Common.getNewFile(fileName);
    }

    public static File getNewFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        return f;
    }

    public static URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        classLoader = Common.class.getClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
            return url;
        }
        return ClassLoader.getSystemResource(resource);
    }

    public static <T> int indexOf(T[] array, T t) {
        if (array == null) {
            throw new NullPointerException("indexOf: array must not be NULL.");
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(t == null ? array[i] == null : t.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }
}

