/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.util;

import java.util.UUID;
import org.coodex.util.Base58;

public class UUIDHelper {
    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static byte[] getUUIDBytes() {
        UUID uuid = UUID.randomUUID();
        long longOne = uuid.getMostSignificantBits();
        long longTwo = uuid.getLeastSignificantBits();
        return new byte[]{(byte)(longOne >>> 56), (byte)(longOne >>> 48), (byte)(longOne >>> 40), (byte)(longOne >>> 32), (byte)(longOne >>> 24), (byte)(longOne >>> 16), (byte)(longOne >>> 8), (byte)longOne, (byte)(longTwo >>> 56), (byte)(longTwo >>> 48), (byte)(longTwo >>> 40), (byte)(longTwo >>> 32), (byte)(longTwo >>> 24), (byte)(longTwo >>> 16), (byte)(longTwo >>> 8), (byte)longTwo};
    }

    public static String getUUIDString() {
        UUID uuid = UUID.randomUUID();
        long mostSigBits = uuid.getMostSignificantBits();
        long leastSigBits = uuid.getLeastSignificantBits();
        return UUIDHelper.digits(mostSigBits >> 32, 8) + UUIDHelper.digits(mostSigBits >> 16, 4) + UUIDHelper.digits(mostSigBits, 4) + UUIDHelper.digits(leastSigBits >> 48, 4) + UUIDHelper.digits(leastSigBits, 12);
    }

    public static String getUUIDStringWithBase58() {
        return Base58.encode(UUIDHelper.getUUIDBytes());
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1000; ++i) {
            System.out.println(UUIDHelper.getUUIDStringWithBase58());
        }
    }
}

