/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.hibernate;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.convert.PlainProperty;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.Property;
import org.directwebremoting.hibernate.H3PropertyDescriptorProperty;
import org.directwebremoting.util.Logger;
import org.hibernate.Hibernate;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class H3BeanConverter
extends BeanConverter
implements Converter {
    protected boolean assumeSession = false;
    protected final Map methods = new HashMap();
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$hibernate$H3BeanConverter == null ? (class$org$directwebremoting$hibernate$H3BeanConverter = H3BeanConverter.class$("org.directwebremoting.hibernate.H3BeanConverter")) : class$org$directwebremoting$hibernate$H3BeanConverter);
    static /* synthetic */ Class class$org$directwebremoting$hibernate$H3BeanConverter;

    public Map getPropertyMapFromObject(Object example, boolean readRequired, boolean writeRequired) throws MarshallException {
        Class clazz = this.getClass(example);
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            HashMap<String, Property> properties = new HashMap<String, Property>();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                if (name.equals("class") || name.equals("hibernateLazyInitializer") || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && descriptor.getWriteMethod() == null) continue;
                if (!this.assumeSession) {
                    String propertyName = descriptor.getName();
                    Method method = this.findGetter(example, propertyName);
                    if (method == null) {
                        log.warn("Failed to find property: " + propertyName);
                        properties.put(name, new PlainProperty(propertyName, null));
                        continue;
                    }
                    if (!Hibernate.isPropertyInitialized((Object)example, (String)propertyName)) {
                        properties.put(name, new PlainProperty(propertyName, null));
                        continue;
                    }
                    Object retval = method.invoke(example, new Object[0]);
                    if (!Hibernate.isInitialized((Object)retval)) {
                        properties.put(name, new PlainProperty(propertyName, null));
                        continue;
                    }
                }
                properties.put(name, new H3PropertyDescriptorProperty(descriptor));
            }
            return properties;
        }
        catch (Exception ex) {
            throw new MarshallException(clazz, (Throwable)ex);
        }
    }

    public Class getClass(Object example) {
        if (example instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)example;
            LazyInitializer initializer = proxy.getHibernateLazyInitializer();
            SessionImplementor implementor = initializer.getSession();
            if (initializer.isUninitialized()) {
                try {
                    if (implementor.isClosed()) {
                        return example.getClass();
                    }
                }
                catch (NoSuchMethodError ex) {
                    // empty catch block
                }
            }
            return initializer.getImplementation().getClass();
        }
        return example.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method findGetter(Object data, String property) throws IntrospectionException {
        String key = data.getClass().getName() + ":" + property;
        Method method = null;
        Map map = this.methods;
        synchronized (map) {
            method = (Method)this.methods.get(key);
        }
        if (method == null) {
            PropertyDescriptor[] props = Introspector.getBeanInfo(data.getClass()).getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getName().equalsIgnoreCase(property)) continue;
                method = props[i].getReadMethod();
            }
            Map map2 = this.methods;
            synchronized (map2) {
                this.methods.put(key, method);
            }
        }
        return method;
    }

    public void setAssumeSession(boolean assumeSession) {
        this.assumeSession = assumeSession;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

