/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TextUtils {
    private static Logger log = LoggerFactory.getLogger(TextUtils.class);

    public static String getText(Object o) {
        StringWriter w = new StringWriter();
        try {
            TextUtils.extractText(o, w, Context.jc);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
        return w.toString();
    }

    public static void extractText(Object o, Writer w) throws Docx4JException {
        TextUtils.extractText(o, w, Context.jc);
    }

    public static void extractText(Object o, Writer w, JAXBContext jc) throws Docx4JException {
        if (o == null) {
            throw new Docx4JException("Can't extractText from null object");
        }
        try {
            Marshaller marshaller = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal(o, (ContentHandler)new TextExtractor(w));
        }
        catch (JAXBException e) {
            throw new Docx4JException("JAXB error marshalling to extractText", (Exception)((Object)e));
        }
    }

    public static void extractText(Object o, Writer w, JAXBContext jc, String uri, String local, Class declaredType) throws Docx4JException {
        try {
            Marshaller marshaller = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal((Object)new JAXBElement(new QName(uri, local), declaredType, o), (ContentHandler)new TextExtractor(w));
        }
        catch (JAXBException e) {
            throw new Docx4JException("JAXB error marshalling to extractText", (Exception)((Object)e));
        }
    }

    public static class TextExtractor
    extends DefaultHandler {
        private Writer out;

        public TextExtractor(Writer out) {
            this.out = out;
        }

        @Override
        public void characters(char[] text, int start, int length) throws SAXException {
            try {
                this.out.write(text, start, length);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }
}

