/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common;

import java.util.Map;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.ConversionHyperlinkHandler;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractWriterRegistry;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractMessageWriter;
import org.docx4j.fonts.RunFontSelector;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.wml.STFldCharType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWmlConversionContext
extends AbstractConversionContext {
    private static Logger log = LoggerFactory.getLogger(AbstractWmlConversionContext.class);
    private Map<String, Writer.TransformState> transformStates = null;
    private AbstractWriterRegistry writerRegistry = null;
    protected Part currentPart = null;
    protected int complexFieldDefinitionLevel = 0;
    protected int footnoteNumberCounter = 0;
    protected int endnoteNumberCounter = 0;
    protected ConversionSectionWrappers conversionSectionWrappers = null;
    protected StyleTree styleTree = null;
    private RunFontSelector runFontSelector = null;

    protected AbstractWmlConversionContext(AbstractWriterRegistry writerRegistry, AbstractMessageWriter messageWriter, AbstractConversionSettings conversionSettings, WordprocessingMLPackage wmlPackage, ConversionSectionWrappers conversionSectionWrappers, RunFontSelector runFontSelector) {
        super(messageWriter, conversionSettings, wmlPackage);
        this.writerRegistry = this.initializeWriterRegistry(writerRegistry);
        this.transformStates = this.initializeTransformStates();
        this.conversionSectionWrappers = conversionSectionWrappers;
        this.styleTree = this.initializeStyleTree();
        this.runFontSelector = runFontSelector;
    }

    @Override
    protected OpcPackage initializeOpcPackage(AbstractConversionSettings conversionSettings, OpcPackage opcPackage) {
        OpcPackage ret = super.initializeOpcPackage(conversionSettings, opcPackage);
        if (!(ret instanceof WordprocessingMLPackage)) {
            throw new IllegalArgumentException("The opcPackage isn't a WordprocessingMLPackage, it is a " + ret.getClass().getName());
        }
        return ret;
    }

    protected AbstractWriterRegistry initializeWriterRegistry(AbstractWriterRegistry registry) {
        return registry;
    }

    protected Map<String, Writer.TransformState> initializeTransformStates() {
        return this.getWriterRegistry().createTransformStates();
    }

    protected StyleTree initializeStyleTree() {
        return this.getWmlPackage().getMainDocumentPart().getStyleTree();
    }

    public Writer.TransformState getTransformState(String name) {
        return this.transformStates != null ? this.transformStates.get(name) : null;
    }

    public WordprocessingMLPackage getWmlPackage() {
        return (WordprocessingMLPackage)this.getOpcPackage();
    }

    public AbstractWriterRegistry getWriterRegistry() {
        return this.writerRegistry;
    }

    public PropertyResolver getPropertyResolver() {
        return this.getWmlPackage().getMainDocumentPart().getPropertyResolver();
    }

    public int getNextEndnoteNumber() {
        return ++this.endnoteNumberCounter;
    }

    public int getNextFootnoteNumber() {
        return ++this.footnoteNumberCounter;
    }

    public void setCurrentPart(Part currentPart) {
        this.currentPart = currentPart;
    }

    public Part getCurrentPart() {
        return this.currentPart;
    }

    public void setCurrentPartMainDocument() {
        this.setCurrentPart(this.getWmlPackage().getMainDocumentPart());
    }

    public ConversionSectionWrappers getSections() {
        return this.conversionSectionWrappers;
    }

    public StyleTree getStyleTree() {
        return this.styleTree;
    }

    public RunFontSelector getRunFontSelector() {
        return this.runFontSelector;
    }

    @Override
    public void handleHyperlink(ConversionHyperlinkHandler.Model model) throws Docx4JException {
        this.getHyperlinkHandler().handleHyperlink(model, this.getOpcPackage(), this.getCurrentPart());
    }

    public void updateComplexFieldDefinition(STFldCharType fieldCharType) {
        if (fieldCharType == STFldCharType.BEGIN) {
            ++this.complexFieldDefinitionLevel;
        } else if (fieldCharType == STFldCharType.SEPARATE) {
            if (this.complexFieldDefinitionLevel == 1) {
                --this.complexFieldDefinitionLevel;
            }
        } else if (fieldCharType == STFldCharType.END && this.complexFieldDefinitionLevel > 0) {
            --this.complexFieldDefinitionLevel;
        }
    }

    public boolean isInComplexFieldDefinition() {
        return this.complexFieldDefinitionLevel > 0;
    }
}

