/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.complexscripts.scripts;

public class KhmerRenderer {
    private static final int XX = 0;
    private static final int CC_COENG = 7;
    private static final int CC_CONSONANT = 1;
    private static final int CC_CONSONANT_SHIFTER = 5;
    private static final int CC_CONSONANT2 = 2;
    private static final int CC_CONSONANT3 = 3;
    private static final int CC_DEPENDENT_VOWEL = 8;
    private static final int CC_ROBAT = 6;
    private static final int CC_SIGN_ABOVE = 9;
    private static final int CC_SIGN_AFTER = 10;
    private static final int CF_ABOVE_VOWEL = 0x20000000;
    private static final int CF_CLASS_MASK = 65535;
    private static final int CF_COENG = 0x8000000;
    private static final int CF_CONSONANT = 0x1000000;
    private static final int CF_DOTTED_CIRCLE = 0x4000000;
    private static final int CF_POS_ABOVE = 131072;
    private static final int CF_POS_AFTER = 65536;
    private static final int CF_POS_BEFORE = 524288;
    private static final int CF_POS_BELOW = 262144;
    private static final int CF_SHIFTER = 0x10000000;
    private static final int CF_SPLIT_VOWEL = 0x2000000;
    private static final int C1 = 0x1000001;
    private static final int C2 = 0x1000002;
    private static final int C3 = 0x1000003;
    private static final int CO = 0xC000007;
    private static final int CS = 335544325;
    private static final int DA = 604110856;
    private static final int DB = 0x4040008;
    private static final int DL = 0x4080008;
    private static final int DR = 67174408;
    private static final int RB = 67239942;
    private static final int SA = 67239945;
    private static final int SP = 67174410;
    private static final int VA = 637665288;
    private static final int VR = 100728840;
    private static final char BA = '\u1794';
    private static final char COENG = '\u17d2';
    private static final String CONYO = Character.toString('\u17d2').concat(Character.toString('\u1789'));
    private static final String CORO = Character.toString('\u17d2').concat(Character.toString('\u179a'));
    private int[] khmerCharClasses = new int[]{0x1000001, 0x1000001, 0x1000001, 0x1000003, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000003, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000003, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000003, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000003, 0x1000002, 0x1000001, 0x1000001, 0x1000001, 0x1000003, 0x1000003, 0x1000001, 0x1000003, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 0x1000001, 67174408, 67174408, 67174408, 604110856, 604110856, 604110856, 604110856, 0x4040008, 0x4040008, 0x4040008, 637665288, 100728840, 100728840, 0x4080008, 0x4080008, 0x4080008, 100728840, 100728840, 67239945, 67174410, 67174410, 335544325, 335544325, 67239945, 67239942, 67239945, 67239945, 67239945, 67239945, 67239945, 0xC000007, 67239945, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67239945, 0, 0};
    private short[][] khmerStateTable = new short[][]{{1, 2, 2, 2, 1, 1, 1, 6, 1, 1, 1, 2}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 3, 4, 5, 6, 16, 17, 1, -1}, {-1, -1, -1, -1, -1, 4, -1, -1, 16, -1, -1, -1}, {-1, -1, -1, -1, 15, -1, -1, 6, 16, 17, 1, 14}, {-1, -1, -1, -1, -1, -1, -1, -1, 20, -1, 1, -1}, {-1, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 12, 13, -1, 10, 16, 17, 1, 14}, {-1, -1, -1, -1, 12, 13, -1, -1, 16, 17, 1, 14}, {-1, -1, -1, -1, 12, 13, -1, 10, 16, 17, 1, 14}, {-1, 11, 11, 11, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 15, -1, -1, -1, 16, 17, 1, 14}, {-1, -1, -1, -1, -1, 13, -1, -1, 16, -1, -1, -1}, {-1, -1, -1, -1, 15, -1, -1, -1, 16, 17, 1, 14}, {-1, -1, -1, -1, -1, -1, -1, -1, 16, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 16, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, 17, 1, 18}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 18}, {-1, -1, -1, -1, -1, -1, -1, 19, -1, -1, -1, -1}, {-1, 1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1}};
    private static final char MARK = '\u17ea';
    private static final char NYO = '\u1789';
    private static final char SA_C = '\u179f';
    private static final char SRAAA = '\u17b6';
    private static final char SRAAU = '\u17c5';
    private static final char SRAE = '\u17c1';
    private static final char SRAIE = '\u17c0';
    private static final char SRAII = '\u17b8';
    private static final char SRAOE = '\u17be';
    private static final char SRAOO = '\u17c4';
    private static final char SRAU = '\u17bb';
    private static final char SRAYA = '\u17bf';
    private static final char TRIISAP = '\u17ca';
    private static final char YO = '\u1799';

    private char strEcombining(char chrInput) {
        int retChar = 32;
        if (chrInput == '\u17be') {
            retChar = 6072;
        } else if (chrInput == '\u17bf') {
            retChar = 6079;
        } else if (chrInput == '\u17c0') {
            retChar = 6080;
        } else if (chrInput == '\u17c4') {
            retChar = 6070;
        } else if (chrInput == '\u17c5') {
            retChar = 6085;
        }
        return (char)retChar;
    }

    private int getCharClass(char uniChar) {
        int retValue = 0;
        int ch = uniChar;
        if (ch > 255 && ch >= 6016 && (ch -= 6016) < this.khmerCharClasses.length) {
            retValue = this.khmerCharClasses[ch];
        }
        return retValue;
    }

    public String render(String strInput) {
        int cursor = 0;
        int state = 0;
        int charCount = strInput.length();
        StringBuilder result = new StringBuilder();
        while (cursor < charCount) {
            String reserved = "";
            String signAbove = "";
            String signAfter = "";
            String base = "";
            String robat = "";
            String shifter = "";
            String vowelBefore = "";
            String vowelBelow = "";
            String vowelAbove = "";
            String vowelAfter = "";
            boolean coeng = false;
            String coeng1 = "";
            String coeng2 = "";
            boolean shifterAfterCoeng = false;
            while (cursor < charCount) {
                char curChar = strInput.charAt(cursor);
                int kChar = this.getCharClass(curChar);
                int charClass = kChar & 0xFFFF;
                try {
                    state = this.khmerStateTable[state][charClass];
                }
                catch (Exception ex) {
                    state = -1;
                }
                if (state < 0) break;
                if (kChar == 0) {
                    reserved = Character.toString(curChar);
                } else if (kChar == 67239945) {
                    signAbove = Character.toString(curChar);
                } else if (kChar == 67174410) {
                    signAfter = Character.toString(curChar);
                } else if (kChar == 0x1000001 || kChar == 0x1000002 || kChar == 0x1000003) {
                    if (coeng) {
                        if ("".equalsIgnoreCase(coeng1)) {
                            coeng1 = Character.toString('\u17d2').concat(Character.toString(curChar));
                        } else {
                            coeng2 = Character.toString('\u17d2').concat(Character.toString(curChar));
                        }
                        coeng = false;
                    } else {
                        base = Character.toString(curChar);
                    }
                } else if (kChar == 67239942) {
                    robat = Character.toString(curChar);
                } else if (kChar == 335544325) {
                    if (!"".equalsIgnoreCase(coeng1)) {
                        shifterAfterCoeng = true;
                    }
                    shifter = Character.toString(curChar);
                } else if (kChar == 0x4080008) {
                    vowelBefore = Character.toString(curChar);
                } else if (kChar == 0x4040008) {
                    vowelBelow = Character.toString(curChar);
                } else if (kChar == 604110856) {
                    vowelAbove = Character.toString(curChar);
                } else if (kChar == 67174408) {
                    vowelAfter = Character.toString(curChar);
                } else if (kChar == 0xC000007) {
                    coeng = true;
                } else if (kChar == 637665288) {
                    vowelBefore = Character.toString('\u17c1');
                    vowelAbove = Character.toString(this.strEcombining(curChar));
                } else if (kChar == 100728840) {
                    vowelBefore = Character.toString('\u17c1');
                    vowelAfter = Character.toString(this.strEcombining(curChar));
                }
                ++cursor;
            }
            String coengBefore = "";
            if (CORO.equalsIgnoreCase(coeng1)) {
                coengBefore = coeng1;
                coeng1 = "";
            } else if (CORO.equalsIgnoreCase(coeng2)) {
                coengBefore = coeng2;
                coeng2 = "";
            }
            if (!("".equalsIgnoreCase(base) || "".equalsIgnoreCase(shifter) || "".equalsIgnoreCase(vowelAbove))) {
                shifter = "";
                vowelBelow = Character.toString('\u17bb');
            }
            if (coeng && "".equalsIgnoreCase(coeng1)) {
                coeng1 = Character.toString('\u17d2');
            } else if (coeng && "".equalsIgnoreCase(coeng2)) {
                coeng2 = Character.toString('\u17ea').concat(Character.toString('\u17d2'));
            }
            String shifter1 = "";
            String shifter2 = "";
            if (shifterAfterCoeng) {
                shifter2 = shifter;
            } else {
                shifter1 = shifter;
            }
            boolean specialCaseBA = false;
            String strMARKSRAAA = Character.toString('\u17ea').concat(Character.toString('\u17b6'));
            String strMARKSRAAU = Character.toString('\u17ea').concat(Character.toString('\u17c5'));
            if (Character.toString('\u1794').equalsIgnoreCase(base) && (Character.toString('\u17b6').equalsIgnoreCase(vowelAfter) || Character.toString('\u17c5').equalsIgnoreCase(vowelAfter) || strMARKSRAAA.equalsIgnoreCase(vowelAfter) || strMARKSRAAU.equalsIgnoreCase(vowelAfter))) {
                specialCaseBA = true;
                if (!"".equalsIgnoreCase(coeng1)) {
                    String coeng1Complete = coeng1.substring(0, coeng1.length() - 1);
                    if (Character.toString('\u1794').equalsIgnoreCase(coeng1Complete) || Character.toString('\u1799').equalsIgnoreCase(coeng1Complete) || Character.toString('\u179f').equalsIgnoreCase(coeng1Complete)) {
                        specialCaseBA = false;
                    }
                }
            }
            String cluster = specialCaseBA ? vowelBefore + coengBefore + base + vowelAfter + robat + shifter1 + coeng1 + coeng2 + shifter2 + vowelBelow + vowelAbove + signAbove + signAfter : vowelBefore + coengBefore + base + robat + shifter1 + coeng1 + coeng2 + shifter2 + vowelBelow + vowelAbove + vowelAfter + signAbove + signAfter;
            result.append(cluster + reserved);
            state = 0;
        }
        return result.toString();
    }
}

