/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.plugin.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.json.JsonConvert;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConvertJackson
implements JsonConvert {
    private static final Logger log = LoggerFactory.getLogger(JsonConvertJackson.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public Map<String, Object> strToMap(String jsonStr) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                return (Map)OBJECT_MAPPER.readValue(jsonStr, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class));
            }
            catch (IOException e) {
                log.error("json\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                throw new FlowException("json\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return new HashMap<String, Object>();
    }

    public <T> T strToBean(String jsonStr, Class<T> clazz) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
            }
            catch (IOException e) {
                log.error("json\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                throw new FlowException("json\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return null;
    }

    public <T> List<T> strToList(String jsonStr) {
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            try {
                return (List)OBJECT_MAPPER.readValue(jsonStr, new TypeReference<List<T>>(){});
            }
            catch (IOException e) {
                log.error("json\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                throw new FlowException("json\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return null;
    }

    public String objToStr(Object variable) {
        if (ObjectUtil.isNotNull((Object)variable)) {
            try {
                return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(variable);
            }
            catch (Exception e) {
                log.error("Map\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                throw new FlowException("Map\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return null;
    }
}

