/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.compiler.BuilderResultUtils;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.lang.descr.BaseDescr;
import org.kie.api.io.Resource;

public class DescrBuildError
extends DroolsError {
    private BaseDescr parentDescr;
    private BaseDescr descr;
    private Object object;
    private String message;
    private int[] errorLines = new int[1];

    public DescrBuildError(BaseDescr parentDescr, BaseDescr descr, Object object, String message) {
        super((Resource)(descr.getResource() != null ? descr.getResource() : (parentDescr != null ? parentDescr.getResource() : null)));
        this.parentDescr = parentDescr;
        this.descr = descr;
        this.object = object;
        this.message = message;
        this.errorLines[0] = this.getLine();
    }

    @Override
    public String getNamespace() {
        return this.parentDescr != null ? this.parentDescr.getNamespace() : this.descr.getNamespace();
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public BaseDescr getDescr() {
        return this.descr;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public int[] getLines() {
        return this.errorLines;
    }

    public int getLine() {
        return this.descr != null ? this.descr.getLine() : -1;
    }

    public int getColumn() {
        return this.descr != null ? this.descr.getColumn() : -1;
    }

    @Override
    public String getMessage() {
        return BuilderResultUtils.getProblemMessage(this.object, this.message, "\n");
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.message).append(" : ").append(this.parentDescr).append("\n");
        return BuilderResultUtils.appendProblems(this.object, builder).toString();
    }
}

