/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.drlxparse;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.PrimitiveType;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.util.ClassUtil;
import org.drools.modelcompiler.util.JavaParserUtil;

public class CoercedExpression {
    private static final List<Class<?>> LITERAL_NUMBER_CLASSES = Arrays.asList(Integer.TYPE, Long.TYPE, Double.TYPE);
    private TypedExpression left;
    private TypedExpression right;
    private static Map<Class, List<Class<?>>> narrowingTypes = new HashMap();

    public CoercedExpression(TypedExpression left, TypedExpression right) {
        this.left = left;
        this.right = right;
    }

    public CoercedExpressionResult coerce() {
        TypedExpression coercedRight;
        Expression rightExpression = this.right.getExpression();
        Class<?> leftClass = this.left.getRawClass();
        Class<?> rightClass = this.right.getRawClass();
        boolean leftIsPrimitive = leftClass.isPrimitive();
        boolean canCoerceLiteralNumberExpr = CoercedExpression.canCoerceLiteralNumberExpr(leftClass);
        if (leftIsPrimitive && canCoerceLiteralNumberExpr && !rightClass.isPrimitive() && !Number.class.isAssignableFrom(rightClass) && !Boolean.class.isAssignableFrom(rightClass) && !String.class.isAssignableFrom(rightClass)) {
            throw new CoercedExpressionException(new InvalidExpressionErrorResult("Comparison operation requires compatible types. Found " + leftClass + " and " + rightClass));
        }
        if (leftIsPrimitive && canCoerceLiteralNumberExpr && rightExpression instanceof LiteralStringValueExpr) {
            Expression coercedLiteralNumberExprToType = this.coerceLiteralNumberExprToType((LiteralStringValueExpr)this.right.getExpression(), leftClass);
            coercedRight = this.right.cloneWithNewExpression(coercedLiteralNumberExprToType);
        } else {
            coercedRight = CoercedExpression.shouldCoerceBToString(this.left, this.right) ? CoercedExpression.coerceToString(this.right) : (CoercedExpression.isNotBinaryExpression(this.right) && this.canBeNarrowed(leftClass, rightClass) && this.right.isNumberLiteral() ? this.castToClass(leftClass) : (CoercedExpression.isNotBinaryExpression(this.right) && this.left.getType().equals(Object.class) && this.right.getType() != Object.class ? this.castToClass(Object.class) : (leftClass == Long.TYPE && rightClass == Integer.TYPE ? this.right.cloneWithNewExpression((Expression)new CastExpr((com.github.javaparser.ast.type.Type)PrimitiveType.longType(), this.right.getExpression())) : (leftClass == Date.class && rightClass == String.class ? CoercedExpression.coerceToDate(this.right) : this.right))));
        }
        TypedExpression coercedLeft = ClassUtil.toNonPrimitiveType(leftClass) == Character.class && CoercedExpression.shouldCoerceBToString(this.right, this.left) ? CoercedExpression.coerceToString(this.left) : this.left;
        return new CoercedExpressionResult(coercedLeft, coercedRight);
    }

    private TypedExpression castToClass(Class<?> clazz) {
        return this.right.cloneWithNewExpression((Expression)new CastExpr(JavaParserUtil.toJavaParserType(clazz, this.right.isPrimitive()), this.right.getExpression()));
    }

    private static TypedExpression coerceToString(TypedExpression typedExpression) {
        Expression expression = typedExpression.getExpression();
        TypedExpression coercedExpression = expression instanceof CharLiteralExpr ? typedExpression.cloneWithNewExpression((Expression)new StringLiteralExpr(((CharLiteralExpr)expression).getValue())) : (typedExpression.isPrimitive() ? typedExpression.cloneWithNewExpression((Expression)new MethodCallExpr((Expression)new NameExpr("String"), "valueOf", NodeList.nodeList((Node[])new Expression[]{expression}))) : (typedExpression.getType() == Object.class ? typedExpression.cloneWithNewExpression((Expression)new MethodCallExpr(expression, "toString")) : typedExpression.cloneWithNewExpression((Expression)new StringLiteralExpr(expression.toString()))));
        return coercedExpression.setType((Type)((Object)String.class));
    }

    private static TypedExpression coerceToDate(TypedExpression typedExpression) {
        MethodCallExpr methodCallExpr = new MethodCallExpr(null, "string_2_date");
        methodCallExpr.addArgument(typedExpression.getExpression());
        return new TypedExpression((Expression)methodCallExpr, (Type)((Object)Date.class));
    }

    public static boolean canCoerceLiteralNumberExpr(Class<?> type) {
        return LITERAL_NUMBER_CLASSES.contains(type);
    }

    private static boolean shouldCoerceBToString(TypedExpression a, TypedExpression b) {
        boolean aIsString = a.getType() == String.class;
        boolean bIsNotString = b.getType() != String.class;
        boolean bIsNotNull = !(b.getExpression() instanceof NullLiteralExpr);
        boolean bIsNotSerializable = b.getType() != Serializable.class;
        boolean bExpressionExists = b.getExpression() != null;
        return bExpressionExists && CoercedExpression.isNotBinaryExpression(b) && aIsString && bIsNotString && bIsNotNull && bIsNotSerializable;
    }

    private static boolean isNotBinaryExpression(TypedExpression e) {
        return e.getExpression() == null || !e.getExpression().isBinaryExpr();
    }

    private Expression coerceLiteralNumberExprToType(LiteralStringValueExpr expr, Class<?> type) {
        if (type == Integer.TYPE) {
            return new IntegerLiteralExpr(expr.getValue());
        }
        if (type == Long.TYPE) {
            return new LongLiteralExpr(expr.getValue().endsWith("l") ? expr.getValue() : expr.getValue() + "l");
        }
        if (type == Double.TYPE) {
            return new DoubleLiteralExpr(expr.getValue().endsWith("d") ? expr.getValue() : expr.getValue() + "d");
        }
        throw new RuntimeException("Unknown literal: " + expr);
    }

    private boolean canBeNarrowed(Class<?> leftType, Class<?> rightType) {
        return Optional.ofNullable(narrowingTypes.get(rightType)).map(a -> a.contains(ClassUtil.toNonPrimitiveType(leftType))).orElse(false);
    }

    static {
        narrowingTypes.put(Short.TYPE, Arrays.asList(Byte.class, Character.class));
        narrowingTypes.put(Character.TYPE, Arrays.asList(Byte.class, Short.class));
        narrowingTypes.put(Integer.TYPE, Arrays.asList(Byte.class, Short.class, Character.class));
        narrowingTypes.put(Long.TYPE, Arrays.asList(Byte.class, Short.class, Character.class, Integer.class));
        narrowingTypes.put(Float.TYPE, Arrays.asList(Byte.class, Short.class, Character.class, Integer.class, Long.class));
        narrowingTypes.put(Double.TYPE, Arrays.asList(Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class));
    }

    public static class CoercedExpressionException
    extends RuntimeException {
        private final InvalidExpressionErrorResult invalidExpressionErrorResult;

        public CoercedExpressionException(InvalidExpressionErrorResult invalidExpressionErrorResult) {
            this.invalidExpressionErrorResult = invalidExpressionErrorResult;
        }

        public InvalidExpressionErrorResult getInvalidExpressionErrorResult() {
            return this.invalidExpressionErrorResult;
        }
    }

    public static class CoercedExpressionResult {
        private final TypedExpression coercedLeft;
        private final TypedExpression coercedRight;

        CoercedExpressionResult(TypedExpression left, TypedExpression coercedRight) {
            this.coercedLeft = left;
            this.coercedRight = coercedRight;
        }

        public TypedExpression getCoercedLeft() {
            return this.coercedLeft;
        }

        public TypedExpression getCoercedRight() {
            return this.coercedRight;
        }
    }
}

