/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.query;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.printer.PrettyPrinter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.IntStream;
import org.drools.modelcompiler.builder.generator.query.FlowDSLQueryGenerator;
import org.drools.modelcompiler.builder.generator.query.PatternDSLQueryGenerator;
import org.drools.modelcompiler.builder.generator.query.QueryDefGenerator;
import org.drools.modelcompiler.builder.generator.query.QueryDefImplGenerator;

public class QueryGenerator {
    public static void main(String[] args) {
        int arity = 10;
        CompilationUnit patternDSL = new CompilationUnit();
        ClassOrInterfaceDeclaration clazzPatternDSL = patternDSL.addClass("PatternDSL");
        QueryGenerator.range(arity).forEach(arity1 -> new PatternDSLQueryGenerator(clazzPatternDSL, arity1).generate());
        System.out.println(new PrettyPrinter().print((Node)clazzPatternDSL));
        CompilationUnit flowDSL = new CompilationUnit();
        ClassOrInterfaceDeclaration clazzFlowDSL = flowDSL.addClass("FlowDSL");
        QueryGenerator.range(arity).forEach(arity1 -> new FlowDSLQueryGenerator(clazzFlowDSL, arity1).generate());
        System.out.println(new PrettyPrinter().print((Node)clazzFlowDSL));
        QueryGenerator.range(arity).forEach(QueryGenerator::generateQueryDef);
        QueryGenerator.range(arity).forEach(QueryGenerator::generateQueryDefImpl);
    }

    private static IntStream range(int arity) {
        return IntStream.range(1, arity + 1);
    }

    private static void generateQueryDefImpl(int arity) {
        QueryDefImplGenerator queryDefImplGenerator = new QueryDefImplGenerator(arity);
        CompilationUnit queryDefImpl = queryDefImplGenerator.generate();
        String generatedClass = new PrettyPrinter().print((Node)queryDefImpl);
        try {
            Path queryimpl = Paths.get("/tmp/", "queryimpl", queryDefImplGenerator.getClassName() + ".java");
            Files.createDirectories(queryimpl.getParent(), new FileAttribute[0]);
            Files.write(queryimpl, generatedClass.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void generateQueryDef(int arity) {
        QueryDefGenerator queryDefGenerator = new QueryDefGenerator(arity);
        CompilationUnit queryDef = queryDefGenerator.generate();
        String generatedClass = new PrettyPrinter().print((Node)queryDef);
        try {
            Path querydef = Paths.get("/tmp/", "querydef", queryDefGenerator.getClassName() + ".java");
            Files.createDirectories(querydef.getParent(), new FileAttribute[0]);
            Files.write(querydef, generatedClass.getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

